/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.ext.MediaElement;
import org.zkoss.zul.impl.XulElement;

public class Track
extends XulElement {
    private boolean _default;
    private String _kind;
    private String _label;
    private String _src;
    private String _srclang;
    private boolean _init = true;

    public Track() {
    }

    public Track(String src) {
        this.setSrc(src);
    }

    public boolean isDefault() {
        return this._default;
    }

    public void setDefault(boolean isDefault) {
        if (this._default != isDefault) {
            this._default = isDefault;
            this.smartUpdate("default", isDefault);
        }
    }

    public String getKind() {
        return this._kind;
    }

    public void setKind(String kind) {
        if (!("subtitles".equals(kind) || "captions".equals(kind) || "descriptions".equals(kind) || "chapters".equals(kind) || "metadata".equals(kind))) {
            throw new WrongValueException("kind cannot be " + kind);
        }
        if (!this._init && "subtitles".equals(kind) && Strings.isEmpty((String)this._srclang)) {
            throw new UiException("srclang cannot be null or empty while kind is subtitles");
        }
        if (!Objects.equals((Object)this._kind, (Object)kind)) {
            this._kind = kind;
            this.smartUpdate("kind", kind);
        }
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        if (!Objects.equals((Object)this._label, (Object)label)) {
            this._label = label;
            this.smartUpdate("label", label);
        }
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (Strings.isEmpty((String)src)) {
            throw new WrongValueException("src cannot be empty of null");
        }
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this.smartUpdate("src", this::getEncodedSrc);
        }
    }

    public String getSrclang() {
        return this._srclang;
    }

    public void setSrclang(String srclang) {
        if (!Objects.equals((Object)this._srclang, (Object)srclang)) {
            this._srclang = srclang;
            this.smartUpdate("srclang", srclang);
        }
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-track";
    }

    protected boolean isChildable() {
        return false;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof MediaElement)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this._init = false;
        if (Strings.isEmpty((String)this._src)) {
            throw new UiException("src must be specified.");
        }
        if ("subtitles".equals(this._kind) && Strings.isEmpty((String)this._srclang)) {
            throw new UiException("srclang must be specified if kind is \"subtitles\"");
        }
        this.render(renderer, "default", this._default);
        this.render(renderer, "kind", this._kind);
        this.render(renderer, "label", this._label);
        this.render(renderer, "src", this.getEncodedSrc());
        this.render(renderer, "srclang", this._srclang);
    }

    private String getEncodedSrc() {
        Desktop dt = this.getDesktop();
        return this._src != null && dt != null ? dt.getExecution().encodeURL(this._src) : null;
    }
}

