/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Groupfoot;
import org.zkoss.zul.GroupsModel;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Row;
import org.zkoss.zul.Rows;
import org.zkoss.zul.impl.GroupsListModel;

public class Group
extends Row {
    private boolean _open = true;
    private transient List<Row> _items;

    public Group() {
        this.init();
    }

    public Group(String label) {
        this();
        this.setLabel(label);
    }

    public <T> Group(String label, T value) {
        this();
        this.setLabel(label);
        this.setValue(value);
    }

    private void init() {
        this._items = new AbstractList<Row>(){

            @Override
            public int size() {
                return Group.this.getItemCount();
            }

            @Override
            public Iterator<Row> iterator() {
                return new IterItems();
            }

            @Override
            public Row get(int index) {
                Rows rows = (Rows)Group.this.getParent();
                if (rows != null) {
                    ListIterator it = rows.getChildren().listIterator(Group.this.getIndex() + 1);
                    for (int i = 0; it.hasNext() && i <= index; ++i) {
                        if (i == index) {
                            return (Row)((Object)it.next());
                        }
                        it.next();
                    }
                }
                throw new IndexOutOfBoundsException("Index: " + index);
            }
        };
    }

    public List<Row> getItems() {
        return this._items;
    }

    public int getItemCount() {
        int[] g;
        Rows rows = (Rows)this.getParent();
        if (rows != null && (g = rows.getGroupsInfoAt(this.getIndex(), true)) != null) {
            if (g[2] == -1) {
                return g[1] - 1;
            }
            return g[1] - 2;
        }
        return 0;
    }

    @Override
    public Group getGroup() {
        return this;
    }

    public int getVisibleItemCount() {
        int count = this.getItemCount();
        int visibleCount = 0;
        for (Row row = (Row)this.getNextSibling(); count-- > 0 && row != null; row = (Row)row.getNextSibling()) {
            if (!row.isVisible()) continue;
            ++visibleCount;
        }
        return visibleCount;
    }

    public int getGroupfootIndex() {
        int[] g;
        Rows rows = (Rows)this.getParent();
        if (rows != null && (g = rows.getGroupsInfoAt(this.getIndex(), true)) != null) {
            return g[2];
        }
        return -1;
    }

    public Groupfoot getGroupfoot() {
        int index = this.getGroupfootIndex();
        if (index < 0) {
            return null;
        }
        Rows rows = (Rows)this.getParent();
        return (Groupfoot)((Object)rows.getChildren().get(index));
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("open", this._open);
            Rows rows = (Rows)this.getParent();
            if (rows != null) {
                rows.addVisibleItemCount(this.isOpen() ? this.getVisibleItemCount() : -this.getVisibleItemCount());
            }
        }
    }

    public String getImgTag() {
        StringBuffer sb = new StringBuffer(64).append("<img src=\"").append(this.getDesktop().getExecution().encodeURL("~./img/spacer.gif")).append("\" class=\"").append(this.getZclass()).append("-img ").append(this.getZclass()).append(this.isOpen() ? "-img-open" : "-img-close").append("\" align=\"absmiddle\"/>");
        String label = this.getLabel();
        if (label != null && label.length() > 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public String getLabel() {
        Component cell = this.getFirstChild();
        return cell != null && cell instanceof Label ? ((Label)cell).getValue() : null;
    }

    public void setLabel(String label) {
        this.autoFirstCell().setValue(label);
    }

    private Label autoFirstCell() {
        Object cell = this.getFirstChild();
        if (cell == null || cell instanceof Label) {
            if (cell == null) {
                cell = new Label();
            }
            cell.applyProperties();
            cell.setParent((Component)this);
            return (Label)((Object)cell);
        }
        throw new UiException("Unsupported child for setLabel: " + cell);
    }

    @Override
    public String getZclass() {
        return this._zclass == null ? "z-group" : this._zclass;
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!this.isOpen()) {
            renderer.render("open", false);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onOpen")) {
            OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
            this._open = evt.isOpen();
            Rows rows = (Rows)this.getParent();
            if (rows != null) {
                ListModel model;
                rows.addVisibleItemCount(this._open ? this.getVisibleItemCount() : -this.getVisibleItemCount());
                Grid grid = this.getGrid();
                if (grid != null && (model = grid.getModel()) instanceof GroupsListModel) {
                    int gindex = rows.getGroupIndex(this.getIndex());
                    GroupsModel gmodel = ((GroupsListModel)model).getGroupsModel();
                    if (this._open) {
                        gmodel.addOpenGroup(gindex);
                    } else {
                        gmodel.removeOpenGroup(gindex);
                    }
                }
            }
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    @Override
    public Object clone() {
        Group clone = (Group)((Object)super.clone());
        clone.init();
        return clone;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
    }

    static {
        Group.addClientEvent(Group.class, (String)"onOpen", (int)8193);
    }

    private class IterItems
    implements Iterator<Row> {
        private final Iterator<Component> _it;
        private int _j;

        private IterItems() {
            this._it = Group.this.getParent().getChildren().listIterator(Group.this.getIndex() + 1);
        }

        @Override
        public boolean hasNext() {
            return this._j < Group.this.getItemCount();
        }

        @Override
        public Row next() {
            ++this._j;
            return (Row)this._it.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

