/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.TimeZone;
import java.util.regex.Pattern;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.SimpleConstraint;
import org.zkoss.zul.mesg.MZul;

public abstract class AbstractSimpleDateTimeConstraint<T extends Comparable<? super T>>
extends SimpleConstraint {
    protected T _beg;
    protected T _end;
    protected TimeZone _tzone = TimeZones.getCurrent();

    public AbstractSimpleDateTimeConstraint(int flags) {
        super(flags);
        this.fixConstraint();
    }

    public AbstractSimpleDateTimeConstraint(int flags, String errmsg) {
        super(flags, errmsg);
        this.fixConstraint();
    }

    @Deprecated
    public AbstractSimpleDateTimeConstraint(String regex, String errmsg) {
        super(regex, errmsg);
        this.fixConstraint();
    }

    public AbstractSimpleDateTimeConstraint(Pattern regex, String errmsg) {
        super(regex, errmsg);
        this.fixConstraint();
    }

    @Deprecated
    public AbstractSimpleDateTimeConstraint(int flags, String regex, String errmsg) {
        super(flags, regex, errmsg);
        this.fixConstraint();
    }

    public AbstractSimpleDateTimeConstraint(int flags, Pattern regex, String errmsg) {
        super(flags, regex, errmsg);
        this.fixConstraint();
    }

    public AbstractSimpleDateTimeConstraint(String constraint) {
        super(constraint);
        this.fixConstraint();
    }

    protected abstract void fixConstraint();

    public T getBeginDate() {
        return this._beg;
    }

    public T getEndDate() {
        return this._end;
    }

    public void setTimeZone(TimeZone tzone) {
        this._tzone = tzone;
        this._finishParseCst = false;
    }

    @Override
    protected int parseConstraint(String constraint) throws UiException {
        if (constraint.startsWith("between")) {
            int j = constraint.indexOf("and", 7);
            if (j < 0) {
                throw new UiException("Constraint syntax error: " + constraint);
            }
            this._beg = this.parseFrom(constraint.substring(7, j));
            this._end = this.parseFrom(constraint.substring(j + 3));
            if (this._beg.compareTo(this._end) > 0) {
                T d = this._beg;
                this._beg = this._end;
                this._end = d;
            }
            return 0;
        }
        if (constraint.startsWith("before") && !constraint.startsWith("before_")) {
            this._end = this.parseFrom(constraint.substring(6));
            return 0;
        }
        if (constraint.startsWith("after") && !constraint.startsWith("after_")) {
            this._beg = this.parseFrom(constraint.substring(5));
            return 0;
        }
        return super.parseConstraint(constraint);
    }

    protected abstract T parseFrom(String var1) throws UiException;

    @Override
    public void validate(Component comp, Object value) throws WrongValueException {
        super.validate(comp, value);
    }

    protected void validate0(Component comp, T value) throws WrongValueException {
        if (this._beg != null && this._beg.compareTo(value) > 0) {
            throw this.outOfRangeValue(comp);
        }
        if (this._end != null && this._end.compareTo(value) < 0) {
            throw this.outOfRangeValue(comp);
        }
    }

    private WrongValueException outOfRangeValue(Component comp) {
        String errmsg = this.getErrorMessage(comp);
        if (errmsg != null) {
            return new WrongValueException(comp, errmsg);
        }
        String s = this._beg != null ? (this._end != null ? this.valueToString(comp, this._beg) + " ~ " + this.valueToString(comp, this._end) : ">= " + this.valueToString(comp, this._beg)) : "<= " + this.valueToString(comp, this._end);
        return new WrongValueException(comp, MZul.OUT_OF_RANGE, (Object)s);
    }

    protected abstract String valueToString(Component var1, T var2);
}

