/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listgroup;
import org.zkoss.zul.impl.LoadStatus;
import org.zkoss.zul.impl.XulElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Listitem
extends XulElement {
    private transient Object _value;
    private int _index = -1;
    private boolean _selected;
    private boolean _disabled;
    private boolean _selectable = true;
    private boolean _loaded;

    public Listitem() {
    }

    public Listitem(String label) {
        this.setLabel(label);
    }

    public <T> Listitem(String label, T value) {
        this.setLabel(label);
        this.setValue(value);
    }

    public Listbox getListbox() {
        return (Listbox)this.getParent();
    }

    public Listgroup getListgroup() {
        Listbox lb = this.getListbox();
        if (lb != null) {
            return lb.getListgroupAt(this.getIndex());
        }
        return null;
    }

    public String getZclass() {
        return this._zclass == null ? "z-listitem" : this._zclass;
    }

    public boolean isCheckable() {
        return this.isSelectable();
    }

    public void setCheckable(boolean checkable) {
        this.setSelectable(checkable);
    }

    public boolean isSelectable() {
        return this._selectable;
    }

    public void setSelectable(boolean selectable) {
        if (this._selectable != selectable) {
            this._selectable = selectable;
            if (!this._selectable) {
                this.setSelected(false);
            }
            this.smartUpdate("selectable", selectable);
        }
    }

    public int getMaxlength() {
        Listbox listbox = this.getListbox();
        return listbox != null ? listbox.getMaxlength() : 0;
    }

    public <T> T getValue() {
        return (T)this._value;
    }

    public <T> void setValue(T value) {
        if (!Objects.equals((Object)this._value, value)) {
            this._value = value;
            Listbox listbox = this.getListbox();
            if (listbox != null) {
                if (listbox.inSelectMold()) {
                    this.smartUpdate("value", this._value);
                } else if (listbox.getName() != null) {
                    this.smartUpdate("value", this._value);
                }
            }
        }
    }

    public void setStubonly(String stubonly) {
        super.setStubonly(stubonly);
    }

    public void setStubonly(boolean stubonly) {
        super.setStubonly(stubonly);
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            Listbox listbox = (Listbox)this.getParent();
            if (listbox != null) {
                listbox.toggleItemSelection(this);
            } else {
                this._selected = selected;
            }
        }
    }

    public String getLabel() {
        Listcell cell = (Listcell)this.getFirstChild();
        return cell != null ? cell.getLabel() : null;
    }

    public void setLabel(String label) {
        this.autoFirstCell().setLabel(label);
    }

    private Listcell autoFirstCell() {
        Listcell cell = (Listcell)this.getFirstChild();
        if (cell == null) {
            cell = new Listcell();
            cell.applyProperties();
            cell.setParent((Component)this);
        }
        return cell;
    }

    public String getSrc() {
        return this.getImage();
    }

    public void setSrc(String src) {
        this.setImage(src);
    }

    public String getImage() {
        Listcell cell = (Listcell)this.getFirstChild();
        return cell != null ? cell.getImage() : null;
    }

    public void setImage(String image) {
        this.autoFirstCell().setImage(image);
    }

    public int getIndex() {
        return this._index;
    }

    void setLoaded(boolean loaded) {
        if (loaded != this._loaded) {
            this._loaded = loaded;
            Listbox listbox = this.getListbox();
            if (listbox != null && listbox.getModel() != null) {
                this.smartUpdate("_loaded", this._loaded);
            }
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    void setIndexDirectly(int index) {
        this.setIndex(index);
    }

    protected void setIndex(int index) {
        this._index = index;
    }

    void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public boolean setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return visible;
        }
        boolean result = super.setVisible(visible);
        Listbox listbox = (Listbox)this.getParent();
        if (listbox != null) {
            Listgroup g;
            if (listbox.inSelectMold()) {
                listbox.invalidate();
            }
            if ((g = listbox.getListgroupAt(this.getIndex())) == null || g.isOpen()) {
                listbox.addVisibleItemCount(visible ? 1 : -1);
            }
        }
        this.smartUpdate("visible", visible);
        return result;
    }

    protected void smartUpdate(String name, Object value) {
        Listbox box = this.getListbox();
        if (this.isVisible() || box == null || !box.inSelectMold()) {
            super.smartUpdate(name, value);
        }
    }

    protected void smartUpdate(String name, boolean value) {
        Listbox box = this.getListbox();
        if (this.isVisible() || box == null || !box.inSelectMold()) {
            super.smartUpdate(name, value);
        }
    }

    protected void smartUpdate(String name, int value) {
        Listbox box = this.getListbox();
        if (this.isVisible() || box == null || !box.inSelectMold()) {
            super.smartUpdate(name, value);
        }
    }

    public String getMold() {
        return this.getParent() != null ? ("select".equals(this.getParent().getMold()) ? "select" : super.getMold()) : super.getMold();
    }

    public void setWidth(String width) {
    }

    public void setHflex(String flex) {
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "selected", this.isSelected());
        this.render(renderer, "disabled", this.isDisabled());
        this.render(renderer, "_loaded", this._loaded ? this._loaded : this.getListbox().getModel() == null);
        renderer.render("_index", this._index);
        if (this._value instanceof String && this.getListbox().getName() != null) {
            this.render(renderer, "value", this._value);
        }
        if (!this.isCheckable()) {
            renderer.render("checkable", false);
        }
    }

    protected void addMoved(Component oldparent, Page oldpg, Page newpg) {
        if (oldparent == null || !((Listbox)oldparent).isLoadingModel()) {
            super.addMoved(oldparent, oldpg, newpg);
        }
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Listbox)) {
            throw new UiException("Listitem's parent must be Listbox, not " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Listcell)) {
            throw new UiException("Unsupported child for listitem: " + child);
        }
        super.beforeChildAdded(child, refChild);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this._value instanceof Serializable) {
            s.writeBoolean(true);
            s.writeObject(this._value);
        } else {
            s.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (s.readBoolean()) {
            this._value = s.readObject();
        }
    }

    @Override
    public Object clone() {
        Listitem clone = (Listitem)((Object)super.clone());
        clone._index = -1;
        return clone;
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements LoadStatus {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Listitem.this);
        }

        public boolean isLoaded() {
            return Listitem.this.isLoaded();
        }

        public void setLoaded(boolean loaded) {
            Listitem.this.setLoaded(loaded);
        }

        public void setIndex(int index) {
            Listitem.this.setIndex(index);
        }
    }
}

