/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.proxy;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.annotation.ImmutableElements;
import org.zkoss.bind.proxy.AbstractCollectionProxy;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.proxy.ProxyHelper;
import org.zkoss.bind.proxy.ProxyNode;
import org.zkoss.bind.proxy.ProxyNodeImpl;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapProxy<K, V>
implements Map<K, V>,
Proxy,
FormProxyObject,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(MapProxy.class);
    private Map<K, V> _cache;
    private boolean _dirty;
    private Map<K, V> _origin;
    private List<Annotation> _callerAnnots;
    private static final long serialVersionUID = 20141226161502L;
    private boolean isImmutableElements;
    private ProxyNode _node;

    public MapProxy(Map<K, V> origin, Annotation[] callerAnnots) {
        this._origin = origin;
        this._cache = new MapForCache(origin.size());
        if (callerAnnots != null) {
            for (Annotation annot : callerAnnots) {
                if (!annot.annotationType().isAssignableFrom(ImmutableElements.class)) continue;
                this.isImmutableElements = true;
                break;
            }
        }
        this.resetFromOrigin();
    }

    @Override
    public Object getOriginObject() {
        return this._origin;
    }

    protected Object replaceOrigin(Object origin) {
        Map<K, V> old = this._origin;
        this._origin = (Map)origin;
        return old;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._cache.entrySet();
    }

    @Override
    public void resetFromOrigin() {
        this._cache.clear();
        this.setDirty(false);
        for (Map.Entry me : ((Map)this.getOriginObject()).entrySet()) {
            Object o = this.createProxyObject(me.getValue());
            this._cache.put(this.createProxyObject(me.getKey()), o);
            if (!(o instanceof FormProxyObject)) continue;
            this.setCreatedProxyPath((FormProxyObject)o, me.getKey());
        }
    }

    @Override
    public void submitToOrigin(BindContext ctx) {
        this._origin.clear();
        for (Map.Entry<K, V> me : this._cache.entrySet()) {
            V value = me.getValue();
            if (value instanceof FormProxyObject) {
                FormProxyObject proxyValue = (FormProxyObject)value;
                proxyValue.submitToOrigin(ctx);
                this._origin.put(me.getKey(), proxyValue.getOriginObject());
                continue;
            }
            this._origin.put(me.getKey(), me.getValue());
        }
        this.setDirty(false);
    }

    public void onDirtyChange() {
        ProxyHelper.callOnDirtyChange(this._node);
    }

    public void onDataChange(Object o) {
        ProxyHelper.callOnDataChange(this._node, new Object[]{o, "."});
    }

    protected void setDirty(boolean d) {
        if (this._dirty != d) {
            this._dirty = d;
            this.onDirtyChange();
        }
        if (d) {
            this.onDataChange(this);
        }
    }

    @Override
    public boolean isFormDirty() {
        if (this._dirty) {
            return true;
        }
        for (Map.Entry<K, V> me : this._cache.entrySet()) {
            if (!(me.getValue() instanceof FormProxyObject) || !((FormProxyObject)me.getValue()).isFormDirty()) continue;
            return true;
        }
        return false;
    }

    public void setHandler(MethodHandler mi) {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public int size() {
        return this._cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this._cache.containsKey(this.createProxyObject(key));
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<V> it = this._cache.values().iterator();
        Object proxyValue = this.createProxyObject(value);
        while (it.hasNext()) {
            if (!AbstractCollectionProxy.testEquals(it.next(), proxyValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this._cache.get(this.createProxyObject(key));
    }

    @Override
    public V put(K key, V value) {
        this.setDirty(true);
        V o = this.createProxyObject(value);
        if (o instanceof FormProxyObject) {
            this.setCreatedProxyPath((FormProxyObject)o, key);
        }
        return this._cache.put(this.createProxyObject(key), o);
    }

    @Override
    public V remove(Object key) {
        this.setDirty(true);
        return this._cache.remove(this.createProxyObject(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.setDirty(true);
        this._cache.clear();
    }

    @Override
    public Set<K> keySet() {
        return this._cache.keySet();
    }

    @Override
    public Collection<V> values() {
        return this._cache.values();
    }

    @Override
    public void setFormOwner(Object owner, FormBinding binding) {
        throw new IllegalAccessError("Not supported");
    }

    private <T> T createProxyObject(T t) {
        return this.isImmutableElements ? t : ProxyHelper.createProxyIfAny(t);
    }

    private void setCreatedProxyPath(FormProxyObject fpo, Object key) {
        fpo.setPath("['" + key + "']", this._node);
    }

    @Override
    public void cacheSavePropertyBinding(String property, SavePropertyBinding s) {
        ProxyHelper.cacheSavePropertyBinding(this._node, this._node.getProperty() + "['" + property + "']", s);
    }

    @Override
    public Set<Pair<String, SavePropertyBinding>> collectCachedSavePropertyBinding() {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public void setPath(String property, ProxyNode parent) {
        if (property == null && this._node != null) {
            this._node.setParent(parent);
        } else {
            this._node = new ProxyNodeImpl(property, parent);
            for (Map.Entry<K, V> e : this._cache.entrySet()) {
                if (!(e.getValue() instanceof FormProxyObject)) continue;
                ((FormProxyObject)this._cache.get(e.getKey())).setPath(null, this._node);
            }
        }
    }

    private class SetHandlerForCache
    implements MethodHandler {
        private Set _origin;

        public SetHandlerForCache(Set origin) {
            this._origin = origin;
        }

        public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
            String mname = method.getName();
            if (mname.equals("contains")) {
                return method.invoke((Object)this._origin, MapProxy.this.createProxyObject(args[0]));
            }
            if (mname.equals("remove")) {
                return method.invoke((Object)this._origin, MapProxy.this.createProxyObject(args[0]));
            }
            return method.invoke((Object)this._origin, args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapForCache<K, V>
    extends LinkedHashMap {
        private transient Set<Map.Entry<K, V>> _entrySetProxy;
        private transient Set<K> _keySetProxy;

        public MapForCache() {
            this._entrySetProxy = null;
            this._keySetProxy = null;
        }

        public MapForCache(int size) {
            super(size);
            this._entrySetProxy = null;
            this._keySetProxy = null;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this._entrySetProxy == null ? this.createProxy(true) : this._entrySetProxy;
        }

        @Override
        public Set<K> keySet() {
            return this._keySetProxy == null ? this.createProxy(false) : this._keySetProxy;
        }

        private Set createProxy(boolean isEntry) {
            Set proxy = null;
            ProxyFactory factory = new ProxyFactory();
            factory.setUseWriteReplace(false);
            factory.setSuperclass(AbstractSet.class);
            factory.createClass();
            try {
                if (isEntry) {
                    proxy = this._entrySetProxy = (Set)factory.createClass().newInstance();
                    ((Proxy)this._entrySetProxy).setHandler((MethodHandler)new SetHandlerForCache(super.entrySet()));
                } else {
                    proxy = this._keySetProxy = (Set)factory.createClass().newInstance();
                    ((Proxy)this._keySetProxy).setHandler((MethodHandler)new SetHandlerForCache(super.keySet()));
                }
            }
            catch (Exception e) {
                log.warn("", (Throwable)e);
            }
            return proxy;
        }
    }
}

