/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Form;
import org.zkoss.bind.annotation.ImmutableFields;
import org.zkoss.bind.impl.AccessInfo;
import org.zkoss.bind.impl.AllocUtil;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.BindingImpl;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.proxy.ProxyHelper;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.xel.ExpressionX;
import org.zkoss.zk.ui.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormBindingImpl
extends BindingImpl
implements FormBinding {
    private static final long serialVersionUID = 1463169907348730644L;
    protected final String _formId;
    protected final AccessInfo _accessInfo;
    private Map<String, ExpressionX> _fieldExprs;

    protected FormBindingImpl(Binder binder, Component comp, String formId, String accessExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs) {
        super(binder, comp, bindingArgs);
        this._formId = formId;
        this._accessInfo = AccessInfo.create(this, accessExpr, Object.class, conditionType, command, this.ignoreTracker());
    }

    protected boolean ignoreTracker() {
        return false;
    }

    @Override
    public Form getFormBean() {
        return ((BinderCtrl)((Object)this.getBinder())).getForm(this.getComponent(), this._formId);
    }

    public <T> Form initFormBean(Object bean, Class<Object> class1, BindContext bindContext) {
        Form form = ((BinderCtrl)((Object)this.getBinder())).getForm(this.getComponent(), this._formId);
        if (form == null) {
            Annotation[] annotations;
            Class[] interfaces = null;
            if (bindContext.getAttribute(String.valueOf(Method.class)) != null && (annotations = (Annotation[])bindContext.getAttribute(String.valueOf(Method.class))) != null) {
                boolean found = false;
                for (Annotation annot : annotations) {
                    if (annot.annotationType() != ImmutableFields.class) continue;
                    found = true;
                    break;
                }
                if (found) {
                    interfaces = new Class[]{ImmutableFields.class};
                }
            }
            form = (Form)ProxyHelper.createFormProxy(bean, class1, interfaces);
            ((BinderCtrl)((Object)this.getBinder())).storeForm(this.getComponent(), this._formId, form);
        }
        if (!(bean instanceof Form) && form instanceof FormProxyObject) {
            ((FormProxyObject)((Object)form)).setFormOwner(bean, this);
        }
        return form;
    }

    @Override
    public String getFormId() {
        return this._formId;
    }

    @Override
    public String getPropertyString() {
        return BindEvaluatorXUtil.getExpressionString(this._accessInfo.getProperty());
    }

    @Override
    public ConditionType getConditionType() {
        return this._accessInfo.getConditionType();
    }

    @Override
    public String getCommandName() {
        return this._accessInfo.getCommandName();
    }

    @Override
    public ExpressionX getFieldExpression(BindEvaluatorX eval, String field) {
        ExpressionX expr;
        ExpressionX expressionX = expr = this._fieldExprs == null ? null : this._fieldExprs.get(field);
        if (expr == null) {
            String property = this.getPropertyString();
            String script = BindELContext.appendFields(property, field);
            expr = eval.parseExpressionX(null, script, Object.class);
            this._fieldExprs = AllocUtil.inst.putMap(this._fieldExprs, field, expr);
        }
        return expr;
    }

    @Override
    public ExpressionX getFormExpression(BindEvaluatorX eval, String field) {
        ExpressionX expr;
        String script = BindELContext.appendFields(this.getFormId(), field);
        ExpressionX expressionX = expr = this._fieldExprs == null ? null : this._fieldExprs.get(script);
        if (expr == null) {
            expr = eval.parseExpressionX(null, script, Object.class);
            this._fieldExprs = AllocUtil.inst.putMap(this._fieldExprs, script, expr);
        }
        return expr;
    }

    public ExpressionX getBaseExpression(BindEvaluatorX eval) {
        ExpressionX expr;
        String property = this.getPropertyString();
        ExpressionX expressionX = expr = this._fieldExprs == null ? null : this._fieldExprs.get(property);
        if (expr == null) {
            String script = property;
            expr = eval.parseExpressionX(null, script, Object.class);
            this._fieldExprs = AllocUtil.inst.putMap(this._fieldExprs, property, expr);
        }
        return expr;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ",component:" + this.getComponent() + ",id:" + this.getFormId() + ",access:" + this.getPropertyString() + ",condition:" + (Object)((Object)this.getConditionType()) + ",command:" + this.getCommandName();
    }
}

