/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.theme;

import java.util.Comparator;
import org.zkoss.web.theme.Theme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardTheme
extends Theme {
    public static final String DEFAULT_NAME = "breeze";
    public static final String DEFAULT_DISPLAY = "Breeze";
    public static final int DEFAULT_PRIORITY = 500;
    public static final ThemeOrigin DEFAULT_ORIGIN = ThemeOrigin.JAR;
    private String _displayName;
    private int _priority;
    private ThemeOrigin _origin;
    private static final Comparator<StandardTheme> _COMPARATOR = new Comparator<StandardTheme>(){

        @Override
        public int compare(StandardTheme t1, StandardTheme t2) {
            if (t1 == null) {
                if (t2 == null) {
                    return 0;
                }
                return 1;
            }
            if (t2 == null) {
                return -1;
            }
            return t1._priority - t2._priority;
        }
    };

    public StandardTheme() {
        super(DEFAULT_NAME);
    }

    public StandardTheme(String themeName) {
        this(themeName, themeName, 500, DEFAULT_ORIGIN);
    }

    public StandardTheme(String themeName, ThemeOrigin origin) {
        this(themeName, themeName, 500, origin);
    }

    public StandardTheme(String themeName, String displayName, int priority) {
        this(themeName, displayName, priority, DEFAULT_ORIGIN);
    }

    public StandardTheme(String themeName, String displayName, int priority, ThemeOrigin origin) {
        if ("".equals(themeName)) {
            throw new IllegalArgumentException("Standard themes should not have blank names");
        }
        super.setName(themeName);
        this._displayName = displayName;
        this._priority = priority;
        this._origin = origin;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public int getPriority() {
        return this._priority;
    }

    public void setPriority(int priority) {
        this._priority = priority;
    }

    public ThemeOrigin getOrigin() {
        return this._origin;
    }

    public static Comparator<StandardTheme> getComparator() {
        return _COMPARATOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThemeOrigin {
        JAR,
        FOLDER;

    }
}

