/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.zkoss.zel.ELContext;
import org.zkoss.zel.ELException;
import org.zkoss.zel.ELResolver;
import org.zkoss.zel.MethodExpression;
import org.zkoss.zel.Util;
import org.zkoss.zel.ValueExpression;
import org.zkoss.zel.impl.util.ClassUtil;

public abstract class ExpressionFactory {
    private static final CacheValue nullTcclFactory = new CacheValue();
    private static final ConcurrentMap<CacheKey, CacheValue> factoryCache = new ConcurrentHashMap<CacheKey, CacheValue>();
    private static final String FACTORY_IMPL_CLASSNAME = "org.zkoss.zel.impl.ExpressionFactoryImpl";

    public static ExpressionFactory newInstance() {
        return ExpressionFactory.newInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExpressionFactory newInstance(Properties properties) {
        Class<?> clazz;
        CacheValue cacheValue;
        ExpressionFactory result = null;
        ClassLoader tccl = ClassUtil.getContextClassLoader(ExpressionFactory.class);
        if (tccl == null) {
            cacheValue = nullTcclFactory;
        } else {
            CacheValue newCacheValue;
            CacheKey key = new CacheKey(tccl);
            cacheValue = (CacheValue)factoryCache.get(key);
            if (cacheValue == null && (cacheValue = factoryCache.putIfAbsent(key, newCacheValue = new CacheValue())) == null) {
                cacheValue = newCacheValue;
            }
        }
        Lock readLock = cacheValue.getLock().readLock();
        readLock.lock();
        try {
            clazz = cacheValue.getFactoryClass();
        }
        finally {
            readLock.unlock();
        }
        if (clazz == null) {
            String className = null;
            try {
                Lock writeLock = cacheValue.getLock().writeLock();
                writeLock.lock();
                try {
                    className = cacheValue.getFactoryClassName();
                    if (className == null) {
                        className = FACTORY_IMPL_CLASSNAME;
                        cacheValue.setFactoryClassName(className);
                    }
                    clazz = tccl == null ? Class.forName(className) : tccl.loadClass(className);
                    cacheValue.setFactoryClass(clazz);
                }
                finally {
                    writeLock.unlock();
                }
            }
            catch (ClassNotFoundException e) {
                throw new ELException("Unable to find ExpressionFactory of type: " + className, e);
            }
        }
        try {
            Constructor<?> constructor = null;
            if (properties != null) {
                try {
                    constructor = clazz.getConstructor(Properties.class);
                }
                catch (SecurityException se) {
                    throw new ELException(se);
                }
                catch (NoSuchMethodException se) {
                    // empty catch block
                }
            }
            result = constructor == null ? (ExpressionFactory)clazz.newInstance() : (ExpressionFactory)constructor.newInstance(properties);
        }
        catch (InstantiationException e) {
            throw new ELException("Unable to create ExpressionFactory of type: " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ELException("Unable to create ExpressionFactory of type: " + clazz.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new ELException("Unable to create ExpressionFactory of type: " + clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Util.handleThrowable(cause);
            throw new ELException("Unable to create ExpressionFactory of type: " + clazz.getName(), e);
        }
        return result;
    }

    public abstract ValueExpression createValueExpression(ELContext var1, String var2, Class<?> var3);

    public abstract ValueExpression createValueExpression(Object var1, Class<?> var2);

    public abstract MethodExpression createMethodExpression(ELContext var1, String var2, Class<?> var3, Class<?>[] var4);

    public abstract Object coerceToType(Object var1, Class<?> var2);

    public ELResolver getStreamELResolver() {
        return null;
    }

    public Map<String, Method> getInitFunctionMap() {
        return null;
    }

    private static class CacheValue {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private String className;
        private WeakReference<Class<?>> ref;

        public ReadWriteLock getLock() {
            return this.lock;
        }

        public String getFactoryClassName() {
            return this.className;
        }

        public void setFactoryClassName(String className) {
            this.className = className;
        }

        public Class<?> getFactoryClass() {
            return this.ref != null ? (Class)this.ref.get() : null;
        }

        public void setFactoryClass(Class<?> clazz) {
            this.ref = new WeakReference(clazz);
        }
    }

    private static class CacheKey {
        private final int hash;
        private final WeakReference<ClassLoader> ref;

        public CacheKey(ClassLoader cl) {
            this.hash = cl.hashCode();
            this.ref = new WeakReference<ClassLoader>(cl);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            ClassLoader thisCl = (ClassLoader)this.ref.get();
            if (thisCl == null) {
                return false;
            }
            return thisCl == ((CacheKey)obj).ref.get();
        }
    }
}

