/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.authentication;

import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import org.codehaus.jettison.json.JSONObject;
import org.gluu.oxauth.client.session.AbstractOAuthFilter;
import org.gluu.oxauth.client.session.OAuthData;
import org.gluu.oxauth.client.util.Configuration;
import org.opensaml.profile.context.ProfileRequestContext;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.model.JwtState;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.util.ArrayHelper;
import org.xdi.util.StringHelper;
import org.xdi.util.security.StringEncrypter;

public class AuthenticationFilter
extends AbstractOAuthFilter {
    public static final String SESSION_CONVERSATION_KEY = "saml_idp_conversation_key";
    private final Pattern authModePattern = Pattern.compile(".+/acr_values/([\\d\\w]+)$");

    public final void init(FilterConfig filterConfig) throws ServletException {
    }

    public final void destroy() {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String urlToRedirectTo;
        if (!this.preFilter(servletRequest, servletResponse, filterChain)) {
            this.log.debug((Object)"Execute validation filter");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        this.log.debug((Object)"No code and no OAuth data found");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try {
            urlToRedirectTo = this.getOAuthRedirectUrl(request, response);
        }
        catch (Exception ex) {
            this.log.error((Object)"Failed to preapre request to OAuth server", (Throwable)ex);
            return;
        }
        this.log.debug((Object)("Redirecting to \"" + urlToRedirectTo + "\""));
        response.sendRedirect(urlToRedirectTo);
    }

    protected final boolean preFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        OAuthData oAuthData;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession(false);
        OAuthData oAuthData2 = oAuthData = session != null ? (OAuthData)session.getAttribute("_oauth_data_") : null;
        if (oAuthData != null) {
            return false;
        }
        String code = AuthenticationFilter.getParameter(request, "code");
        this.log.trace((Object)("code value: " + code));
        return !StringHelper.isNotEmpty((String)code);
    }

    public String getOAuthRedirectUrl(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String authorizeUrl = this.getPropertyFromInitParams(null, "oxauth.authorize.url", null);
        String clientScopes = this.getPropertyFromInitParams(null, "oxauth.client.scope", null);
        String clientId = this.getPropertyFromInitParams(null, "oxauth.client.id", null);
        String clientSecret = this.getPropertyFromInitParams(null, "oxauth.client.password", null);
        if (clientSecret != null) {
            try {
                clientSecret = StringEncrypter.defaultInstance().decrypt(clientSecret, Configuration.instance().getCryptoPropertyValue());
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error((Object)"Failed to decrypt property: oxauth.client.password", (Throwable)ex);
            }
        }
        String redirectUri = this.constructRedirectUrl(request);
        List<String> scopes = Arrays.asList(clientScopes.split(" "));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        String key = request.getParameter("conversation");
        request.getSession().setAttribute(SESSION_CONVERSATION_KEY, (Object)key);
        ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)key, (HttpServletRequest)request);
        String relyingPartyId = "";
        RelyingPartyContext relyingPartyCtx = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class);
        if (relyingPartyCtx != null) {
            relyingPartyId = relyingPartyCtx.getRelyingPartyId();
            this.log.info((Object)("relyingPartyId found: " + relyingPartyId));
        } else {
            this.log.warn((Object)"No RelyingPartyContext was available");
        }
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        JwtState jwtState = new JwtState(SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        if (relyingPartyId != null && !"".equals(relyingPartyId)) {
            String additionalClaims = String.format("{relyingPartyId: '%s'}", relyingPartyId);
            jwtState.setAdditionalClaims(new JSONObject(additionalClaims));
        } else {
            this.log.warn((Object)"No relyingPartyId was available");
        }
        String encodedState = jwtState.getEncodedJwt();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        Cookie currentShibstateCookie = this.getCurrentShibstateCookie(request);
        if (currentShibstateCookie != null) {
            String requestUri = this.decodeCookieValue(currentShibstateCookie.getValue());
            this.log.debug((Object)("requestUri = \"" + requestUri + "\""));
            String authenticationMode = this.determineAuthenticationMode(requestUri);
            if (StringHelper.isNotEmpty((String)authenticationMode)) {
                this.log.debug((Object)("acr_values = \"" + authenticationMode + "\""));
                authorizationRequest.setAcrValues(Arrays.asList(authenticationMode));
                this.updateShibstateCookie(response, currentShibstateCookie, requestUri, "/acr_values/" + authenticationMode);
            }
        }
        HttpSession session = request.getSession(false);
        session.setAttribute("_auth_state_", (Object)encodedState);
        session.setAttribute("_auth_nonce_", (Object)nonce);
        return authorizeUrl + "?" + authorizationRequest.getQueryString();
    }

    private Cookie getCurrentShibstateCookie(HttpServletRequest request) {
        Object[] cookies = request.getCookies();
        if (ArrayHelper.isEmpty((Object[])cookies)) {
            return null;
        }
        Object resultCookie = null;
        for (Object cookie : cookies) {
            String cookieName = cookie.getName();
            if (!cookieName.startsWith("_shibstate_")) continue;
            if (resultCookie == null) {
                resultCookie = cookie;
                continue;
            }
            if (cookieName.compareTo(resultCookie.getName()) <= 0) continue;
            resultCookie = cookie;
        }
        if (resultCookie == null) {
            return null;
        }
        return resultCookie;
    }

    private void updateShibstateCookie(HttpServletResponse response, Cookie shibstateCookie, String requestUri, String acrPathParam) {
        if (!requestUri.contains(acrPathParam)) {
            return;
        }
        String newRequestUri = requestUri.replace(acrPathParam, "");
        Cookie updateShibstateCookie = this.cloneCokie(shibstateCookie, this.encodeCookieValue(newRequestUri), shibstateCookie.getMaxAge());
        response.addCookie(updateShibstateCookie);
    }

    private Cookie cloneCokie(Cookie sourceCookie, String newValue, int maxAge) {
        Cookie resultCookie = new Cookie(sourceCookie.getName(), newValue);
        resultCookie.setPath("/");
        resultCookie.setMaxAge(maxAge);
        resultCookie.setVersion(1);
        resultCookie.setSecure(true);
        return resultCookie;
    }

    private String decodeCookieValue(String cookieValue) {
        if (StringHelper.isEmpty((String)cookieValue)) {
            return null;
        }
        return URLDecoder.decode(cookieValue);
    }

    private String encodeCookieValue(String cookieValue) {
        if (StringHelper.isEmpty((String)cookieValue)) {
            return null;
        }
        return URLEncoder.encode(cookieValue);
    }

    private String determineAuthenticationMode(String requestUri) {
        return this.determineAuthenticationParameter(requestUri, this.authModePattern);
    }

    private String determineAuthenticationParameter(String requestUri, Pattern pattern) {
        Matcher matcher = pattern.matcher(requestUri);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

