/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.validation;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.gluu.oxauth.client.authentication.SimplePrincipal;

public class CustomHttpServletRequest
extends HttpServletRequestWrapper {
    private final Map<String, String> customParameters = new HashMap<String, String>();
    private String username;
    private Principal userPrincipal;

    public CustomHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    public void addCustomParameter(String name, String value) {
        this.customParameters.put(name, value);
    }

    public String getParameter(String name) {
        String originalParameter = super.getParameter(name);
        if (originalParameter != null) {
            return originalParameter;
        }
        return this.customParameters.get(name);
    }

    public Principal getUserPrincipal() {
        Principal principal = super.getUserPrincipal();
        if (principal != null) {
            return principal;
        }
        return this.userPrincipal;
    }

    public String getRemoteUser() {
        String user = super.getRemoteUser();
        if (user != null && !user.isEmpty()) {
            return user;
        }
        return this.username;
    }

    public void setRemoteUser(String username) {
        this.username = username;
        this.userPrincipal = new SimplePrincipal(username);
    }
}

