/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.logout;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gluu.oxauth.client.session.AbstractOAuthFilter;
import org.gluu.oxauth.client.session.SignOutHandler;

public class LogoutFilter
extends AbstractOAuthFilter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        String urlToRedirectTo;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession(false);
        try {
            SignOutHandler signOutHandler = SignOutHandler.instance();
            urlToRedirectTo = signOutHandler.getOAuthLogoutUrl(request);
            if (urlToRedirectTo == null) {
                urlToRedirectTo = signOutHandler.constructRedirectUrl(request);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"Failed to preapre request to OAuth server", (Throwable)ex);
            if (session != null) {
                session.invalidate();
            }
            return;
        }
        if (session != null) {
            session.invalidate();
        }
        this.log.debug((Object)("Redirecting to \"" + urlToRedirectTo + "\""));
        response.sendRedirect(urlToRedirectTo);
    }
}

