/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.validation;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gluu.oxauth.client.session.AbstractOAuthFilter;
import org.gluu.oxauth.client.session.OAuthData;
import org.gluu.oxauth.client.util.Configuration;
import org.gluu.oxauth.client.validation.CustomHttpServletRequest;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.util.StringHelper;
import org.xdi.util.security.StringEncrypter;

public class OAuthValidationFilter
extends AbstractOAuthFilter {
    public final void init(FilterConfig filterConfig) throws ServletException {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.log.debug((Object)"Attempting to validate grants");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.preFilter(servletRequest, servletResponse, filterChain)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        HttpSession session = request.getSession(false);
        String conversation = null;
        if (session != null) {
            conversation = (String)session.getAttribute("conversation");
            if (conversation == null || conversation.isEmpty()) {
                throw new ServletException("IDP v3 conversation param is null or empty");
            }
            this.log.debug((Object)("########## SESSION conversation = " + conversation));
        } else {
            this.log.error((Object)"Session not created yet");
        }
        String code = OAuthValidationFilter.getParameter(request, "code");
        String idToken = OAuthValidationFilter.getParameter(request, "id_token");
        this.log.debug((Object)("Attempting to validate code: " + code + " and id_token: " + idToken));
        try {
            OAuthData oAuthData = this.getOAuthData(request, code, idToken);
            session.setAttribute("_oauth_data_", (Object)oAuthData);
        }
        catch (Exception ex) {
            response.setStatus(403);
            this.log.warn((Object)"Failed to validate code and id_token", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        CustomHttpServletRequest customRequest = new CustomHttpServletRequest(request);
        customRequest.addCustomParameter("conversation", conversation);
        filterChain.doFilter((ServletRequest)customRequest, (ServletResponse)response);
    }

    protected final boolean preFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        String code = OAuthValidationFilter.getParameter(request, "code");
        String idToken = OAuthValidationFilter.getParameter(request, "id_token");
        return StringHelper.isNotEmpty((String)code) && StringHelper.isNotEmpty((String)idToken);
    }

    private OAuthData getOAuthData(HttpServletRequest request, String authorizationCode, String idToken) throws Exception {
        String oAuthAuthorizeUrl = this.getPropertyFromInitParams(null, "oxauth.authorize.url", null);
        String oAuthHost = this.getOAuthHost(oAuthAuthorizeUrl);
        String oAuthTokenUrl = this.getPropertyFromInitParams(null, "oxauth.token.url", null);
        String oAuthUserInfoUrl = this.getPropertyFromInitParams(null, "oxauth.userinfo.url", null);
        String oAuthClientId = this.getPropertyFromInitParams(null, "oxauth.client.id", null);
        String oAuthClientPassword = this.getPropertyFromInitParams(null, "oxauth.client.password", null);
        if (oAuthClientPassword != null) {
            try {
                oAuthClientPassword = StringEncrypter.defaultInstance().decrypt(oAuthClientPassword, Configuration.instance().getCryptoPropertyValue());
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error((Object)"Failed to decrypt property: oxauth.client.password", (Throwable)ex);
            }
        }
        String scopes = OAuthValidationFilter.getParameter(request, "scope");
        this.log.trace((Object)("scopes : " + scopes));
        this.log.trace((Object)"Getting access token");
        TokenClient tokenClient1 = new TokenClient(oAuthTokenUrl);
        String redirectURL = this.constructRedirectUrl(request);
        TokenResponse tokenResponse = tokenClient1.execAuthorizationCode(authorizationCode, redirectURL, oAuthClientId, oAuthClientPassword);
        this.log.trace((Object)("tokenResponse : " + tokenResponse));
        this.log.trace((Object)("tokenResponse.getErrorType() : " + tokenResponse.getErrorType()));
        String accessToken = tokenResponse.getAccessToken();
        this.log.trace((Object)("accessToken : " + accessToken));
        this.log.info((Object)"Session validation successful. User is logged in");
        UserInfoClient userInfoClient = new UserInfoClient(oAuthUserInfoUrl);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        OAuthData oAuthData = new OAuthData();
        oAuthData.setHost(oAuthHost);
        List uidValues = (List)userInfoResponse.getClaims().get("user_name");
        if (uidValues == null || uidValues.size() == 0) {
            this.log.error((Object)"User infor response doesn't contains uid claim");
            return null;
        }
        oAuthData.setUserUid((String)uidValues.get(0));
        oAuthData.setAccessToken(accessToken);
        oAuthData.setAccessTokenExpirationInSeconds(tokenResponse.getExpiresIn());
        oAuthData.setScopes(scopes);
        oAuthData.setIdToken(idToken);
        this.log.trace((Object)("User uid: " + oAuthData.getUserUid()));
        return oAuthData;
    }

    private String getOAuthHost(String oAuthAuthorizeUrl) {
        try {
            URL url = new URL(oAuthAuthorizeUrl);
            return String.format("%s://%s:%s", url.getProtocol(), url.getHost(), url.getPort());
        }
        catch (MalformedURLException ex) {
            this.log.error((Object)("Invalid oAuth authorization URI: " + oAuthAuthorizeUrl), (Throwable)ex);
            return null;
        }
    }

    public void destroy() {
    }
}

