/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.session;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gluu.oxauth.client.session.OAuthData;
import org.gluu.oxauth.client.util.Configuration;
import org.jboss.resteasy.client.ClientRequest;

public final class SignOutHandler {
    protected final Log log = LogFactory.getLog(this.getClass());

    private SignOutHandler() {
    }

    public static SignOutHandler instance() {
        return SignOutHandlerSingleton.INSTANCE;
    }

    public String getOAuthLogoutUrl(HttpServletRequest servletRequest) {
        HttpServletRequest request = servletRequest;
        HttpSession session = request.getSession(false);
        if (session == null) {
            this.log.trace((Object)"There is no exising session");
            return null;
        }
        OAuthData oAuthData = (OAuthData)session.getAttribute("_oauth_data_");
        if (oAuthData == null) {
            this.log.trace((Object)"There is no OAuthData in the session");
            return null;
        }
        ClientRequest clientRequest = new ClientRequest(Configuration.instance().getPropertyValue("oxauth.logout.url"));
        clientRequest.queryParameter("id_token_hint", (Object)oAuthData.getAccessToken());
        clientRequest.queryParameter("post_logout_redirect_uri", (Object)this.constructRedirectUrl(request));
        session.removeAttribute("_oauth_data_");
        try {
            return clientRequest.getUri();
        }
        catch (Exception ex) {
            this.log.error((Object)"Failed to prepare OAuth log out URL", (Throwable)ex);
            return null;
        }
    }

    protected final String constructRedirectUrl(HttpServletRequest request) {
        this.log.trace((Object)"Starting constructRedirectUrl");
        String redirectUri = null;
        String[] redirectUriParameters = (String[])request.getParameterMap().get("post_logout_redirect_uri");
        if (redirectUriParameters != null && redirectUriParameters.length > 0) {
            redirectUri = redirectUriParameters[0];
        }
        this.log.trace((Object)("redirectUri from request = " + redirectUri));
        if (redirectUri == null || redirectUri.equals("")) {
            int serverPort = request.getServerPort();
            redirectUri = serverPort == 80 || serverPort == 443 ? String.format("%s://%s%s", request.getScheme(), request.getServerName(), "/identity/authentication/finishlogout") : String.format("%s://%s:%s%s", request.getScheme(), request.getServerName(), request.getServerPort(), "/identity");
        }
        this.log.trace((Object)("Final redirectUri = " + redirectUri));
        return redirectUri;
    }

    private static class SignOutHandlerSingleton {
        static SignOutHandler INSTANCE = new SignOutHandler();

        private SignOutHandlerSingleton() {
        }
    }
}

