/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.util;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.gluu.oxauth.client.authentication.SimplePrincipal;
import org.gluu.oxauth.client.session.OAuthData;
import org.gluu.oxauth.client.util.AbstractConfigurationFilter;

public final class HttpServletRequestWrapperFilter
extends AbstractConfigurationFilter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        SimplePrincipal principal = this.retrievePrincipalFromSessionOrRequest(servletRequest);
        if (principal == null) {
            this.log.trace((Object)"There is no principal");
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            filterChain.doFilter((ServletRequest)new OAuthHttpServletRequestWrapper((HttpServletRequest)servletRequest, principal), servletResponse);
        }
    }

    protected SimplePrincipal retrievePrincipalFromSessionOrRequest(ServletRequest servletRequest) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession(false);
        OAuthData oAuthData = (OAuthData)(session == null ? request.getAttribute("_oauth_data_") : session.getAttribute("_oauth_data_"));
        if (oAuthData == null) {
            this.log.trace((Object)"There is no OAuthData in session");
            return null;
        }
        SimplePrincipal principanl = new SimplePrincipal(oAuthData.getUserUid());
        return principanl;
    }

    private final class OAuthHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final SimplePrincipal principal;

        private OAuthHttpServletRequestWrapper(HttpServletRequest request, SimplePrincipal principal) {
            super(request);
            this.principal = principal;
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public String getRemoteUser() {
            return this.principal != null ? this.principal.getName() : null;
        }
    }
}

