/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.validation;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gluu.oxauth.client.session.AbstractOAuthFilter;
import org.gluu.oxauth.client.session.OAuthData;
import org.gluu.oxauth.client.util.Configuration;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.client.ValidateTokenClient;
import org.xdi.oxauth.client.ValidateTokenResponse;
import org.xdi.util.AssertionHelper;
import org.xdi.util.StringHelper;
import org.xdi.util.security.StringEncrypter;

public class OAuthValidationFilter
extends AbstractOAuthFilter {
    private String oAuthAuthorizeUrl;
    private String oAuthTokenUrl;
    private String oAuthValidationUrl;
    private String oAuthCheckSessionUrl;
    private String oAuthUserInfoUrl;
    private String oAuthHost;
    private String oAuthClientId;
    private String oAuthClientPassword;

    public final void init(FilterConfig filterConfig) throws ServletException {
        this.oAuthAuthorizeUrl = this.getPropertyFromInitParams(filterConfig, "oxauth.authorize.url", null);
        if (this.oAuthAuthorizeUrl != null) {
            this.oAuthHost = this.getOAuthHost(this.oAuthAuthorizeUrl);
        }
        this.oAuthTokenUrl = this.getPropertyFromInitParams(filterConfig, "oxauth.token.url", null);
        this.oAuthValidationUrl = this.getPropertyFromInitParams(filterConfig, "oxauth.token.validation.url", null);
        this.oAuthCheckSessionUrl = this.getPropertyFromInitParams(filterConfig, "oxauth.checksession.url", null);
        this.oAuthUserInfoUrl = this.getPropertyFromInitParams(filterConfig, "oxauth.userinfo.url", null);
        this.oAuthClientId = this.getPropertyFromInitParams(filterConfig, "oxauth.client.id", null);
        this.oAuthClientPassword = this.getPropertyFromInitParams(filterConfig, "oxauth.client.password", null);
        if (this.oAuthClientPassword != null) {
            try {
                this.oAuthClientPassword = StringEncrypter.defaultInstance().decrypt(this.oAuthClientPassword, Configuration.instance().getCryptoPropertyValue("encodeSalt"));
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error((Object)"Failed to decrypt property: oxauth.client.password", (Throwable)ex);
            }
        }
        AssertionHelper.assertNotNull((Object)this.oAuthAuthorizeUrl, (String)"oxauth.authorize.urlcannot be null");
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.log.debug((Object)"Attempting to validate grants");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.preFilter(servletRequest, servletResponse, filterChain)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        HttpSession session = request.getSession(false);
        String code = OAuthValidationFilter.getParameter(request, "code");
        String idToken = OAuthValidationFilter.getParameter(request, "id_token");
        this.log.debug((Object)("Attempting to validate code: " + code + " and id_token: " + idToken));
        try {
            OAuthData oAuthData = this.getOAuthData(request, code, idToken);
            session.setAttribute("_oauth_data_", (Object)oAuthData);
        }
        catch (Exception ex) {
            response.setStatus(403);
            this.log.warn((Object)"Failed to validate code and id_token", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected final boolean preFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        String code = OAuthValidationFilter.getParameter(request, "code");
        String idToken = OAuthValidationFilter.getParameter(request, "id_token");
        return StringHelper.isNotEmpty((String)code) && StringHelper.isNotEmpty((String)idToken);
    }

    private OAuthData getOAuthData(HttpServletRequest request, String authorizationCode, String idToken) throws Exception {
        String scopes = OAuthValidationFilter.getParameter(request, "scope");
        this.log.trace((Object)("scopes : " + scopes));
        this.log.trace((Object)"Getting access token");
        TokenClient tokenClient1 = new TokenClient(this.oAuthTokenUrl);
        String redirectURL = this.constructRedirectUrl(request);
        TokenResponse tokenResponse = tokenClient1.execAuthorizationCode(authorizationCode, redirectURL, this.oAuthClientId, this.oAuthClientPassword);
        this.log.trace((Object)("tokenResponse : " + tokenResponse));
        this.log.trace((Object)("tokenResponse.getErrorType() : " + tokenResponse.getErrorType()));
        String accessToken = tokenResponse.getAccessToken();
        this.log.trace((Object)("accessToken : " + accessToken));
        this.log.trace((Object)"Validating access token ");
        ValidateTokenClient validateTokenClient = new ValidateTokenClient(this.oAuthValidationUrl);
        ValidateTokenResponse tokenValidationResponse = validateTokenClient.execValidateToken(accessToken);
        this.log.trace((Object)(" response3.getStatus() : " + tokenValidationResponse.getStatus()));
        this.log.info((Object)("validate check session status:" + tokenValidationResponse.getStatus()));
        if (tokenValidationResponse.getErrorDescription() != null) {
            this.log.error((Object)("validate token status message:" + tokenValidationResponse.getErrorDescription()));
        }
        if (tokenValidationResponse.getStatus() == 200) {
            this.log.info((Object)"Session validation successful. User is logged in");
            UserInfoClient userInfoClient = new UserInfoClient(this.oAuthUserInfoUrl);
            UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
            OAuthData oAuthData = new OAuthData();
            oAuthData.setHost(this.oAuthHost);
            List uidValues = (List)userInfoResponse.getClaims().get("sub");
            if (uidValues == null || uidValues.size() == 0) {
                this.log.error((Object)"User infor response doesn't contains uid claim");
                return null;
            }
            oAuthData.setUserUid((String)uidValues.get(0));
            oAuthData.setAccessToken(accessToken);
            oAuthData.setAccessTokenExpirationInSeconds(tokenValidationResponse.getExpiresIn());
            oAuthData.setScopes(scopes);
            oAuthData.setIdToken(idToken);
            this.log.trace((Object)("User uid:" + oAuthData.getUserUid()));
            return oAuthData;
        }
        this.log.error((Object)"Token validation failed. User is NOT logged in");
        return null;
    }

    private String getOAuthHost(String oAuthAuthorizeUrl) {
        try {
            URL url = new URL(oAuthAuthorizeUrl);
            return String.format("%s://%s:%s", url.getProtocol(), url.getHost(), url.getPort());
        }
        catch (MalformedURLException ex) {
            this.log.error((Object)("Invalid oAuth authorization URI: " + oAuthAuthorizeUrl), (Throwable)ex);
            return null;
        }
    }

    public void destroy() {
    }
}

