/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.uma.demo.rs.server;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.testng.Assert;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.ClientUtils;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class RegisterClientManual {
    public static void main(String[] args) throws Exception {
        String registrationEndpoint = "https://kantara.gluu.org/oxauth/seam/resource/restv1/oxauth/register";
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxUma Demo RP", StringUtils.spaceSeparatedToList((String)"https://kantara.gluu.org/rp/rp.html"));
        registerRequest.setResponseTypes(Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN, ResponseType.TOKEN));
        RegisterClient registerClient = new RegisterClient(registrationEndpoint);
        registerClient.setRequest(registerRequest);
        registerClient.setExecutor(RegisterClientManual.getClientExecutor());
        RegisterResponse registerResponse = registerClient.exec();
        ClientUtils.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
    }

    public static ClientExecutor getClientExecutor() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        return new ApacheHttpClient4Executor(RegisterClientManual.createHttpClientTrustAll());
    }

    public static HttpClient createHttpClientTrustAll() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        SSLSocketFactory sf = new SSLSocketFactory(new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }, (X509HostnameVerifier)new AllowAllHostnameVerifier());
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)sf));
        PoolingClientConnectionManager ccm = new PoolingClientConnectionManager(registry);
        return new DefaultHttpClient((ClientConnectionManager)ccm);
    }
}

