/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.uam.demo.rp;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.python.google.common.base.Strings;
import org.testng.annotations.Test;
import org.xdi.oxauth.client.uma.CreateRptService;
import org.xdi.oxauth.client.uma.RptAuthorizationRequestService;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.client.uma.wrapper.UmaClient;
import org.xdi.oxauth.model.uma.PermissionTicket;
import org.xdi.oxauth.model.uma.RPTResponse;
import org.xdi.oxauth.model.uma.RptAuthorizationRequest;
import org.xdi.oxauth.model.uma.RptAuthorizationResponse;
import org.xdi.oxauth.model.uma.UmaConfiguration;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.uma.demo.common.gwt.Phones;
import org.xdi.uma.demo.rp.server.Configuration;
import org.xdi.uma.demo.rp.server.PhoneService;
import org.xdi.uma.demo.rp.server.Uma;
import org.xdi.util.InterfaceRegistry;
import org.xdi.util.Util;

public class RpSimulationTest {
    @Test
    public void testRpt() {
        UmaConfiguration umaAmConfiguration;
        Configuration c = Configuration.getInstance();
        if (c != null && (umaAmConfiguration = UmaClientFactory.instance().createMetaDataConfigurationService(c.getUmaMetaDataUrl()).getMetadataConfiguration()) != null) {
            InterfaceRegistry.put(UmaConfiguration.class, (Object)umaAmConfiguration);
        }
    }

    @Test
    public void workflow() throws Exception {
        try {
            this.doCall("", "");
        }
        catch (Exception e) {
            System.out.println("Response: unauthorized.");
        }
        UmaConfiguration umaConfiguration = UmaClientFactory.instance().createMetaDataConfigurationService(Configuration.getInstance().getUmaMetaDataUrl(), Uma.getClientExecutor()).getMetadataConfiguration();
        CreateRptService rptService = UmaClientFactory.instance().createRequesterPermissionTokenService(umaConfiguration);
        Configuration c = Configuration.getInstance();
        Token aat = UmaClient.requestAat((String)c.getTokenUrl(), (String)c.getUmaAatClientId(), (String)c.getUmaAatClientSecret(), (String[])new String[0]);
        if (aat != null) {
            RPTResponse rptResponse = rptService.createRPT("Bearer " + aat.getAccessToken(), c.amHost());
            try {
                this.doCall(rptResponse.getRpt(), aat.getAccessToken());
            }
            catch (ClientResponseFailure e) {
                ClientResponse response = e.getResponse();
                if (response.getStatus() == Response.Status.FORBIDDEN.getStatusCode()) {
                    System.out.println("Request forbidden.");
                    PermissionTicket ticketWrapper = (PermissionTicket)response.getEntity(PermissionTicket.class);
                    String ticket = ticketWrapper.getTicket();
                    System.out.println("RS returns permission ticket: " + ticket);
                    RptAuthorizationRequest authorizationRequest = new RptAuthorizationRequest(rptResponse.getRpt(), ticket);
                    System.out.println("Try to authorize RPT with ticket...");
                    RptAuthorizationRequestService rptAuthorizationService = UmaClientFactory.instance().createAuthorizationRequestService(umaConfiguration);
                    RptAuthorizationResponse clientAuthorizationResponse = rptAuthorizationService.requestRptPermissionAuthorization("Bearer " + aat.getAccessToken(), c.amHost(), authorizationRequest);
                    if (clientAuthorizationResponse != null && !Strings.isNullOrEmpty((String)clientAuthorizationResponse.getRpt())) {
                        System.out.println("RPT is authorized.");
                        this.doCall(clientAuthorizationResponse.getRpt(), aat.getAccessToken());
                    }
                }
            }
        } else {
            System.out.println("ERROR: AAT is null!!!");
        }
    }

    private void doCall(String p_rpt, String p_aat) throws IOException {
        System.out.println("Call phones service...");
        PhoneService phoneService = PhoneService.getInstance();
        Phones phones = phoneService.getPhones(p_rpt, p_aat);
        System.out.println(Util.asPrettyJson((Object)phones));
    }

    public static void main(String[] args) {
        String s = "{\"command\":\"register_site\",\"params\" : {\"authorization_redirect_uri\" : \"https://opencart.gl/index.php?route=module/socl_login&logout_from_gluu=aruesa\",\"post_logout_redirect_uri\" : \"https://opencart.gl/index.php?route=module/socl_login&logout_from_gluu=exist\",\"application_type\" : \"web\",\"redirect_uris\" :[\"https://opencart.gl/index.php?route=module/socl_login\"],\"acr_values\" : [],\"scope\" : [\"openid\",\"profile\",\"email\",\"address\",\"clientinfo\",\"mobile_phone\",\"phone\"],\"client_jwks_uri\" : null,\"client_token_endpoint_auth_method\" : null,\"client_request_uris\" : null,\"contacts\" : [\"vlad.karapetyan.1988@mail.ru\"],\"grant_types\" : [\"authorization_code\"],\"response_types\" : [\"code\"],\"client_logout_uris\" : [\"https://opencart.gl/index.php?route=module/socl_login&logout_from_gluu=exist\"]}}";
        System.out.println(s.length());
    }
}

