/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.logging.log4j.LogManager;
import org.gluu.oxtrust.api.client.OxTrustAPIException;
import org.gluu.oxtrust.api.client.OxTrustClient;
import org.gluu.oxtrust.api.test.APITestException;
import org.gluu.oxtrust.api.test.ClientTestScenary;

public class TestMain {
    private static final org.apache.logging.log4j.Logger logger = LogManager.getLogger(TestMain.class);
    private Properties configuration;
    private String baseURI;
    private String login;
    private String password;

    public void init() throws IOException {
        String confFile = "conf/configuration.properties";
        this.configuration = new Properties();
        this.configuration.load(new FileInputStream("conf/configuration.properties"));
        this.baseURI = this.configuration.getProperty("baseURI");
        this.login = this.configuration.getProperty("login");
        this.password = this.configuration.getProperty("password");
    }

    public static void initLogging() {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter());
        Logger.global.addHandler(handler);
    }

    public void run() throws Exception {
        OxTrustClient client = new OxTrustClient(this.baseURI, this.login, this.password);
        ClientTestScenary clientScenary = new ClientTestScenary(client);
        clientScenary.run();
    }

    public static void main(String[] args) {
        TestMain.initLogging();
        try {
            TestMain test = new TestMain();
            test.init();
            test.run();
        }
        catch (APITestException e) {
            logger.error("Some test failured with exception", (Throwable)e);
            System.exit(1);
        }
        catch (OxTrustAPIException e) {
            logger.error("Some oxTrust API call failured with exception", (Throwable)e);
            System.exit(1);
        }
        catch (Throwable t) {
            logger.error("Runtime exception", t);
            System.exit(1);
        }
    }
}

