/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.test;

import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gluu.oxtrust.api.client.OxTrustAPIException;
import org.gluu.oxtrust.api.client.OxTrustClient;
import org.gluu.oxtrust.api.client.saml.TrustRelationshipClient;
import org.gluu.oxtrust.api.saml.SAMLTrustRelationshipShort;
import org.gluu.oxtrust.api.test.APITestException;
import org.gluu.oxtrust.model.GluuMetadataSourceType;
import org.gluu.oxtrust.model.GluuSAMLTrustRelationship;

public class SamlTestScenary {
    private static final Logger logger = LogManager.getLogger(SamlTestScenary.class);
    private final OxTrustClient client;
    private final Random random = new Random();

    public SamlTestScenary(OxTrustClient client) {
        this.client = client;
    }

    public void run() throws APITestException, OxTrustAPIException {
        TrustRelationshipClient samlClient = this.client.getTrustRelationshipClient();
        List<SAMLTrustRelationshipShort> trustRelationships = samlClient.list();
        GluuSAMLTrustRelationship trGenerated = this.generateRandomeSingleTrustRelationship();
        String inum = samlClient.create(trGenerated);
        GluuSAMLTrustRelationship trReaded = (GluuSAMLTrustRelationship)samlClient.read(inum);
        if (!trGenerated.getDisplayName().equals(trReaded.getDisplayName())) {
            throw new APITestException("Readed TrustRelationship isn't equal to saved");
        }
        trReaded.setDescription("description changed");
        samlClient.update(trReaded, inum);
        trustRelationships = samlClient.list();
        if (!this.checkListForTrustRelationship(trustRelationships, inum)) {
            throw new APITestException("TrustRelationship really not saved");
        }
        samlClient.delete(inum);
        trustRelationships = samlClient.list();
        if (this.checkListForTrustRelationship(trustRelationships, inum)) {
            throw new APITestException("TrustRelationship really not deleted");
        }
        trustRelationships = samlClient.listAllActiveTrustRelationships();
        trustRelationships = samlClient.listAllFederations();
        trustRelationships = samlClient.listAllSAMLTrustRelationships(10);
        trustRelationships = samlClient.searchTrustRelationships("*", 10);
    }

    private GluuSAMLTrustRelationship generateRandomeSingleTrustRelationship() {
        int randTestNumber = Math.abs(this.random.nextInt());
        GluuSAMLTrustRelationship tr = new GluuSAMLTrustRelationship();
        tr.setDisplayName("test_TrustRelationship_#" + randTestNumber);
        tr.setDescription("test TrustRelationship #" + randTestNumber);
        tr.setSpMetaDataSourceType(GluuMetadataSourceType.FILE);
        tr.setUrl("https://ce.gluu.info");
        tr.setSpMetaDataFN("38CBAF15F4E4708200029736F2AB0006BF5CFB85-sp-metadata.xml");
        return tr;
    }

    private boolean checkListForTrustRelationship(List<SAMLTrustRelationshipShort> trustRelationships, String inum) {
        for (SAMLTrustRelationshipShort tr : trustRelationships) {
            if (!inum.equals(tr.getInum())) continue;
            return true;
        }
        return false;
    }
}

