/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.proxy;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gluu.oxtrust.api.GluuGroupApi;
import org.gluu.oxtrust.api.GluuPersonApi;

public interface GroupApiProxy {
    public static final String PATH_INUM = "/{inum}";
    public static final String INUM = "inum";

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<GluuGroupApi> getGroups(@DefaultValue(value="0") @QueryParam(value="size") int var1);

    @GET
    @Path(value="/{inum}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GluuGroupApi getGroup(@PathParam(value="inum") String var1);

    @GET
    @Path(value="/search")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<GluuGroupApi> getSearchGroups(@QueryParam(value="pattern") @NotNull String var1, @QueryParam(value="size") int var2);

    @GET
    @Path(value="/{inum}/members")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<GluuPersonApi> getGroupMembers(@PathParam(value="inum") String var1);

    @POST
    @Path(value="/{inum}/members/{minum}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addGroupMember(@PathParam(value="inum") String var1, @PathParam(value="minum") String var2);

    @DELETE
    @Path(value="/{inum}/members/{minum}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response removeGroupMember(@PathParam(value="inum") String var1, @PathParam(value="minum") String var2);

    @DELETE
    @Path(value="/{inum}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void deleteGroup(@PathParam(value="inum") String var1);

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GluuGroupApi createGroup(GluuGroupApi var1);

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GluuGroupApi updateGroup(GluuGroupApi var1);
}

