/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.client.util;

import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gluu.oxtrust.api.client.util.OxTrustAuthorizationException;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.client.uma.UmaTokenService;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.token.ClientAssertionType;
import org.xdi.oxauth.model.uma.UmaMetadata;
import org.xdi.oxauth.model.uma.UmaTokenResponse;
import org.xdi.util.StringHelper;

public class UmaAuthorizationClient {
    private static final Logger logger = LogManager.getLogger(UmaAuthorizationClient.class);
    private String rpt;
    private final String umaAatClientId;
    private final String umaAatClientKeyId;
    private final String umaAatClientJksPath;
    private final String umaAatClientJksPassword;
    private final ResteasyClient client = new ResteasyClientBuilder().build();

    public UmaAuthorizationClient(String domain, String umaAatClientId, String umaAatClientJksPath, String umaAatClientJksPassword, String umaAatClientKeyId) {
        ResteasyWebTarget target = this.client.target(domain);
        this.umaAatClientId = umaAatClientId;
        this.umaAatClientJksPath = umaAatClientJksPath;
        this.umaAatClientJksPassword = umaAatClientJksPassword;
        this.umaAatClientKeyId = umaAatClientKeyId;
    }

    public String getAuthenticationHeader() {
        return StringHelper.isEmpty((String)this.rpt) ? null : "Bearer " + this.rpt;
    }

    boolean authorize(Response response) throws OxTrustAuthorizationException {
        boolean value = false;
        if (response.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            try {
                String[] headerKeyValues;
                String permissionTicketResponse = response.getHeaderString("WWW-Authenticate");
                String permissionTicket = null;
                String asUri = null;
                for (String headerKeyValue : headerKeyValues = StringHelper.split((String)permissionTicketResponse, (String)",")) {
                    if (headerKeyValue.startsWith("ticket=")) {
                        permissionTicket = headerKeyValue.substring(7);
                    }
                    if (!headerKeyValue.startsWith("as_uri=")) continue;
                    asUri = headerKeyValue.substring(7);
                }
                value = !StringHelper.isEmpty(asUri) && !StringHelper.isEmpty(permissionTicket) && this.obtainAuthorizedRpt(asUri, permissionTicket);
            }
            catch (Exception e) {
                throw new OxTrustAuthorizationException(e.getMessage(), e);
            }
        }
        return value;
    }

    private boolean obtainAuthorizedRpt(String asUri, String ticket) throws OxTrustAuthorizationException {
        try {
            return StringUtils.isNotBlank((String)this.getAuthorizedRpt(asUri, ticket));
        }
        catch (Exception e) {
            throw new OxTrustAuthorizationException(e.getMessage(), e);
        }
    }

    private String getAuthorizedRpt(String asUri, String ticket) throws OxTrustAuthorizationException {
        try {
            UmaMetadata umaMetadata = UmaClientFactory.instance().createMetadataService(asUri).getMetadata();
            if (umaMetadata == null) {
                throw new OxTrustAuthorizationException(String.format("Failed to load valid UMA metadata configuration from: %s", asUri));
            }
            TokenRequest tokenRequest = this.getAuthorizationTokenRequest(umaMetadata);
            UmaTokenService tokenService = UmaClientFactory.instance().createTokenService(umaMetadata);
            UmaTokenResponse rptResponse = tokenService.requestJwtAuthorizationRpt(ClientAssertionType.JWT_BEARER.toString(), tokenRequest.getClientAssertion(), GrantType.OXAUTH_UMA_TICKET.getValue(), ticket, null, null, null, null, null);
            if (rptResponse == null) {
                throw new OxTrustAuthorizationException("UMA RPT token response is invalid");
            }
            if (StringUtils.isBlank((String)rptResponse.getAccessToken())) {
                throw new OxTrustAuthorizationException("UMA RPT is invalid");
            }
            this.rpt = rptResponse.getAccessToken();
            return this.rpt;
        }
        catch (Exception ex) {
            throw new OxTrustAuthorizationException(ex.getMessage(), ex);
        }
    }

    private TokenRequest getAuthorizationTokenRequest(UmaMetadata umaMetadata) throws OxTrustAuthorizationException {
        try {
            List aliases;
            OxAuthCryptoProvider cryptoProvider;
            if (StringHelper.isEmpty((String)this.umaAatClientJksPath) || StringHelper.isEmpty((String)this.umaAatClientJksPassword)) {
                throw new OxTrustAuthorizationException("UMA JKS keystore path or password is empty");
            }
            try {
                cryptoProvider = new OxAuthCryptoProvider(this.umaAatClientJksPath, this.umaAatClientJksPassword, null);
            }
            catch (Exception ex) {
                throw new OxTrustAuthorizationException("Failed to initialize crypto provider");
            }
            String keyId = this.umaAatClientKeyId;
            if (StringHelper.isEmpty((String)keyId) && (aliases = cryptoProvider.getKeyAliases()).size() > 0) {
                keyId = (String)aliases.get(0);
            }
            if (StringHelper.isEmpty((String)keyId)) {
                throw new OxTrustAuthorizationException("UMA keyId is empty");
            }
            TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
            tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
            tokenRequest.setAuthUsername(this.umaAatClientId);
            tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
            tokenRequest.setAlgorithm(cryptoProvider.getSignatureAlgorithm(keyId));
            tokenRequest.setKeyId(keyId);
            tokenRequest.setAudience(umaMetadata.getTokenEndpoint());
            return tokenRequest;
        }
        catch (Exception ex) {
            throw new OxTrustAuthorizationException("Failed to get client token", ex);
        }
    }
}

