/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.client.util;

import javax.ws.rs.ClientErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gluu.oxtrust.api.client.OxTrustAPIException;

public class AbstractClient<T> {
    private static final Logger logger = LogManager.getLogger(AbstractClient.class);
    public static final int HTTP_OK = 200;
    protected WebTarget webTarget;
    protected Client client;
    protected Class<T> entityClass;

    public AbstractClient(Class<T> entityClass, Client client, String baseURI, String path) {
        this.entityClass = entityClass;
        this.client = client;
        this.webTarget = client.target(baseURI).path(path);
    }

    public T read(String id) throws ClientErrorException {
        WebTarget resource = this.webTarget.path("read/{id}").resolveTemplate("id", (Object)id);
        return (T)resource.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).get(this.entityClass);
    }

    public String create(T requestEntity) throws OxTrustAPIException {
        Response response = this.webTarget.path("create").request().post(Entity.entity(requestEntity, (String)"application/json"));
        if (response.getStatus() != 200) {
            throw new OxTrustAPIException("Response error. HTTP code: " + response.getStatus() + ", reason phrase: " + response.getStatusInfo().getReasonPhrase(), response.getStatus());
        }
        String id = (String)response.readEntity(String.class);
        response.close();
        return id;
    }

    public String add(T requestEntity) throws OxTrustAPIException {
        WebTarget resource = this.webTarget;
        System.out.println("Final Url:" + resource.getUri().toString());
        Response response = resource.request().post(Entity.entity(requestEntity, (String)"application/json"));
        if (response.getStatus() != 200) {
            System.out.println("Error:" + response.getStatus());
            throw new OxTrustAPIException("Response error. HTTP code: " + response.getStatus() + ", reason phrase: " + response.getStatusInfo().getReasonPhrase(), response.getStatus());
        }
        response.close();
        return (String)response.readEntity(String.class);
    }

    public boolean update(T requestEntity, String id) {
        WebTarget resource = this.webTarget.path("update/{id}").resolveTemplate("id", (Object)id);
        Response response = resource.request().put(Entity.entity(requestEntity, (String)"application/json"));
        int code = response.getStatus();
        response.close();
        return code == 200;
    }

    public boolean delete(String id) {
        WebTarget resource = this.webTarget.path("delete/{id}").resolveTemplate("id", (Object)id);
        Response response = resource.request(new String[]{"text/plain"}).delete();
        int code = response.getStatus();
        response.close();
        return code == 200;
    }

    public boolean remove(String inum) {
        WebTarget resource = this.webTarget.path("/{inum}").resolveTemplate("inum", (Object)inum);
        System.out.println("Final Url:" + resource.getUri().toString());
        Response response = resource.request(new String[]{"text/plain"}).delete();
        response.close();
        return response.getStatus() == 200;
    }
}

