/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.client.saml;

import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gluu.oxtrust.api.client.OxTrustAPIException;
import org.gluu.oxtrust.api.client.util.AbstractClient;
import org.gluu.oxtrust.api.saml.SAMLTrustRelationshipShort;
import org.gluu.oxtrust.model.GluuSAMLTrustRelationship;
import org.xdi.model.TrustContact;

public class TrustRelationshipClient
extends AbstractClient<GluuSAMLTrustRelationship> {
    private static final Logger logger = LogManager.getLogger(TrustRelationshipClient.class);
    private static final String PATH = "/restv1/api/saml/tr/";

    public TrustRelationshipClient(Client client, String baseURI) {
        super(GluuSAMLTrustRelationship.class, client, baseURI, PATH);
    }

    public List<SAMLTrustRelationshipShort> list() {
        WebTarget resource = this.webTarget.path("list");
        GenericType<List<SAMLTrustRelationshipShort>> responseType = new GenericType<List<SAMLTrustRelationshipShort>>(){};
        return (List)resource.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).get((GenericType)responseType);
    }

    public List<SAMLTrustRelationshipShort> listAllFederations() {
        WebTarget resource = this.webTarget.path("list_all_federations");
        GenericType<List<SAMLTrustRelationshipShort>> responseType = new GenericType<List<SAMLTrustRelationshipShort>>(){};
        return (List)resource.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).get((GenericType)responseType);
    }

    public List<SAMLTrustRelationshipShort> listAllActiveTrustRelationships() {
        WebTarget resource = this.webTarget.path("list_all_active_trust_relationships");
        GenericType<List<SAMLTrustRelationshipShort>> responseType = new GenericType<List<SAMLTrustRelationshipShort>>(){};
        return (List)resource.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).get((GenericType)responseType);
    }

    public List<SAMLTrustRelationshipShort> listAllOtherFederations(String trustRelationshipInum) {
        WebTarget resource = this.webTarget.path("list_all_other_federations/{inum}").resolveTemplate("inum", (Object)trustRelationshipInum);
        GenericType<List<SAMLTrustRelationshipShort>> responseType = new GenericType<List<SAMLTrustRelationshipShort>>(){};
        return (List)resource.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).get((GenericType)responseType);
    }

    public List<SAMLTrustRelationshipShort> listAllSAMLTrustRelationships(int sizeLimit) {
        WebTarget resource = this.webTarget.path("list_all_saml_trust_relationships").queryParam("size_limit", new Object[]{sizeLimit});
        GenericType<List<SAMLTrustRelationshipShort>> responseType = new GenericType<List<SAMLTrustRelationshipShort>>(){};
        return (List)resource.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).get((GenericType)responseType);
    }

    public List<SAMLTrustRelationshipShort> listDeconstructedTrustRelationships(String trustRelationshipInum) {
        WebTarget resource = this.webTarget.path("list_deconstructed_trust_relationships/{inum}").resolveTemplate("inum", (Object)trustRelationshipInum);
        GenericType<List<SAMLTrustRelationshipShort>> responseType = new GenericType<List<SAMLTrustRelationshipShort>>(){};
        return (List)resource.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).get((GenericType)responseType);
    }

    public List<SAMLTrustRelationshipShort> searchTrustRelationships(String pattern, int sizeLimit) {
        WebTarget resource = this.webTarget.path("search_trust_relationships").queryParam("pattern", new Object[]{pattern}).queryParam("size_limit", new Object[]{sizeLimit});
        GenericType<List<SAMLTrustRelationshipShort>> responseType = new GenericType<List<SAMLTrustRelationshipShort>>(){};
        return (List)resource.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).get((GenericType)responseType);
    }

    public List<TrustContact> getContacts(String trustRelationshipInum) {
        WebTarget resource = this.webTarget.path("/get_contacts/{inum}").resolveTemplate("inum", (Object)trustRelationshipInum);
        GenericType<List<TrustContact>> responseType = new GenericType<List<TrustContact>>(){};
        return (List)resource.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).get((GenericType)responseType);
    }

    public void setContacts(String trustRelationshipInum, List<TrustContact> contacts) throws OxTrustAPIException {
        Response response = this.webTarget.path("set_contacts/{inum}").resolveTemplate("inum", (Object)trustRelationshipInum).request().post(Entity.entity(contacts, (String)"application/json"));
        if (response.getStatus() != 200) {
            throw new OxTrustAPIException("Response error. HTTP code: " + response.getStatus() + ", reason phrase: " + response.getStatusInfo().getReasonPhrase(), response.getStatus());
        }
    }

    public void setMetadata(String trustRelationshipInum, String metadata) throws OxTrustAPIException {
        Response response = this.webTarget.path("set_metadata/{inum}").resolveTemplate("inum", (Object)trustRelationshipInum).request().post(Entity.entity((Object)metadata, (String)"application/xml"));
        if (response.getStatus() != 200) {
            throw new OxTrustAPIException("Response error. HTTP code: " + response.getStatus() + ", reason phrase: " + response.getStatusInfo().getReasonPhrase(), response.getStatus());
        }
    }

    public void setMetadataURL(String trustRelationshipInum, String url) throws OxTrustAPIException {
        Response response = this.webTarget.path("set_metadata_url/{inum}").resolveTemplate("inum", (Object)trustRelationshipInum).request().post(Entity.entity((Object)url, (String)"text/plain"));
        if (response.getStatus() != 200) {
            throw new OxTrustAPIException("Response error. HTTP code: " + response.getStatus() + ", reason phrase: " + response.getStatusInfo().getReasonPhrase(), response.getStatus());
        }
    }

    public void setCertificate(String trustRelationshipInum, String certificate) throws OxTrustAPIException {
        Response response = this.webTarget.path("set_certificate/{inum}").resolveTemplate("inum", (Object)trustRelationshipInum).request().post(Entity.entity((Object)certificate, (String)"text/plain"));
        if (response.getStatus() != 200) {
            throw new OxTrustAPIException("Response error. HTTP code: " + response.getStatus() + ", reason phrase: " + response.getStatusInfo().getReasonPhrase(), response.getStatus());
        }
    }
}

