/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.client.group;

import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gluu.oxtrust.api.client.util.AbstractClient;
import org.gluu.oxtrust.model.GluuGroup;

public class GroupClient
extends AbstractClient<GluuGroup> {
    private static final Logger logger = LogManager.getLogger(GroupClient.class);
    private static final String PATH = "/restv1/api/groups";

    public GroupClient(Client client, String baseURI) {
        super(GluuGroup.class, client, baseURI, PATH);
    }

    public List<GluuGroup> list() {
        logger.debug("Final Url:" + this.webTarget.getUri().toString());
        GenericType<List<GluuGroup>> responseType = new GenericType<List<GluuGroup>>(){};
        return (List)this.webTarget.request().get((GenericType)responseType);
    }

    public List<GluuGroup> searchGroups(String pattern, int size) {
        WebTarget resource = this.webTarget.path("search").queryParam("pattern", new Object[]{pattern}).queryParam("size", new Object[]{size});
        logger.debug("Final Url:" + resource.getUri().toString());
        GenericType<List<GluuGroup>> responseType = new GenericType<List<GluuGroup>>(){};
        return (List)resource.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).get((GenericType)responseType);
    }

    public GluuGroup getGroup(String inum) {
        logger.debug("Final Url:" + this.webTarget.getUri().toString());
        WebTarget resource = this.webTarget.path("/{inum}").resolveTemplate("inum", (Object)inum);
        return (GluuGroup)resource.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).get(GluuGroup.class);
    }
}

