/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.client;

import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.gluu.oxtrust.api.client.certificates.CertificatesClient;
import org.gluu.oxtrust.api.client.group.GroupClient;
import org.gluu.oxtrust.api.client.people.PeopleClient;
import org.gluu.oxtrust.api.client.saml.TrustRelationshipClient;
import org.gluu.oxtrust.api.client.util.ClientRequestAuthorizationFilter;
import org.gluu.oxtrust.api.client.util.ClientRequestBASICAuthorizationFilter;
import org.gluu.oxtrust.api.client.util.ClientRequestLoggingFilter;
import org.gluu.oxtrust.api.client.util.ClientResponseLoggingFilter;
import org.gluu.oxtrust.api.client.util.UmaAuthorizationClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public class OxTrustClient {
    private final String baseURI;
    private final TrustRelationshipClient trustRelationshipClient;
    private final GroupClient groupClient;
    private final PeopleClient peopleClient;
    private final CertificatesClient certificatesClient;
    private final SSLContext sslContext;
    private final HostnameVerifier verifier;
    private final ResteasyClient client;

    public OxTrustClient(String baseURI, String domain, String umaAatClientId, String umaAatClientJksPath, String umaAatClientJksPassword, String umaAatClientKeyId) throws NoSuchAlgorithmException, KeyManagementException {
        this.baseURI = baseURI;
        UmaAuthorizationClient umaAuthorizationClient = new UmaAuthorizationClient(domain, umaAatClientId, umaAatClientJksPath, umaAatClientJksPassword, umaAatClientKeyId);
        String authenticationToken = umaAuthorizationClient.getAuthenticationHeader();
        this.sslContext = this.initSSLContext();
        this.verifier = this.initHostnameVerifier();
        this.client = new ResteasyClientBuilder().sslContext(this.sslContext).hostnameVerifier(this.verifier).register(JacksonJsonProvider.class).register((Object)new ClientRequestAuthorizationFilter(authenticationToken)).register((Object)new ClientRequestLoggingFilter()).register((Object)new ClientResponseLoggingFilter()).build();
        this.trustRelationshipClient = new TrustRelationshipClient((Client)this.client, baseURI);
        this.groupClient = new GroupClient((Client)this.client, baseURI);
        this.peopleClient = new PeopleClient((Client)this.client, baseURI);
        this.certificatesClient = new CertificatesClient((Client)this.client, baseURI);
    }

    public OxTrustClient(String baseURI, String user, String password) throws NoSuchAlgorithmException, KeyManagementException, UnsupportedEncodingException {
        this.baseURI = baseURI;
        this.sslContext = this.initSSLContext();
        this.verifier = this.initHostnameVerifier();
        this.client = new ResteasyClientBuilder().sslContext(this.sslContext).hostnameVerifier(this.verifier).register(JacksonJsonProvider.class).register((Object)new ClientRequestBASICAuthorizationFilter(user, password)).register((Object)new ClientRequestLoggingFilter()).register((Object)new ClientResponseLoggingFilter()).build();
        this.trustRelationshipClient = new TrustRelationshipClient((Client)this.client, baseURI);
        this.groupClient = new GroupClient((Client)this.client, baseURI);
        this.peopleClient = new PeopleClient((Client)this.client, baseURI);
        this.certificatesClient = new CertificatesClient((Client)this.client, baseURI);
    }

    private SSLContext initSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }}, new SecureRandom());
        return context;
    }

    private HostnameVerifier initHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession ssls) {
                return true;
            }
        };
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public TrustRelationshipClient getTrustRelationshipClient() {
        return this.trustRelationshipClient;
    }

    public GroupClient getGroupClient() {
        return this.groupClient;
    }

    public PeopleClient getPeopleClient() {
        return this.peopleClient;
    }

    public CertificatesClient getCertificatesClient() {
        return this.certificatesClient;
    }

    public void close() {
        this.client.close();
    }
}

