/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.users;

import java.util.Date;
import java.util.List;
import java.util.Random;
import org.gluu.oxtrust.api.GluuPersonApi;
import org.gluu.oxtrust.api.users.PeopleRepository;
import org.gluu.persist.model.base.GluuStatus;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class UserApiTest {
    private GluuPersonApi user;
    private PeopleRepository peopleRepository;
    private static boolean canRunOtherTest = false;

    @BeforeClass
    public static void testConnection() {
        try {
            PeopleRepository peopleRepositoryImpl = new PeopleRepository();
            peopleRepositoryImpl.searchPersons("user");
            canRunOtherTest = true;
        }
        catch (Exception e) {
            System.out.println("***********************");
            System.out.println("ERROR OCCURS: POSSIBLE CAUSES");
            System.out.println("1. MAKE SURE THE HOSTNAME DEFINE IN CONFIGURATION FILE IS RESOLVABLE");
            System.out.println("2. MAKE SURE THE CERTS FILE ARE IMPORTED IN JAVA KEY STORE");
            System.out.println("***********************");
        }
    }

    @Before
    public void setup() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.peopleRepository = new PeopleRepository();
    }

    @Test
    public void getPeopleTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("List people");
        System.out.println("==================");
        List<GluuPersonApi> peoples = this.peopleRepository.getAllPersons();
        Assert.assertNotNull(peoples);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void addUserTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Add user");
        System.out.println("==================");
        int sizeBefore = this.peopleRepository.getAllPersons().size();
        this.user = this.peopleRepository.createPerson(this.generateNewUser());
        int sizeAfter = this.peopleRepository.getAllPersons().size();
        Assert.assertNotNull((Object)this.user);
        Assert.assertNotNull((Object)this.user.getInum());
        Assert.assertTrue((sizeBefore + 1 == sizeAfter ? 1 : 0) != 0);
        System.out.println(this.user.toString());
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void updateUserTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.user = this.peopleRepository.createPerson(this.generateNewUser());
        String displayName = "updated Display name";
        String inum = this.user.getInum();
        this.user.setDisplayName(displayName);
        System.out.println("=================" + inum);
        System.out.println("==================");
        this.user = this.peopleRepository.updatePerson(this.user);
        Assert.assertEquals((Object)displayName, (Object)this.user.getDisplayName());
        Assert.assertEquals((Object)inum, (Object)this.user.getInum());
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void searchUserTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Search people");
        System.out.println("==================");
        String pattern = "user";
        List<GluuPersonApi> foundPeoples = this.peopleRepository.searchPersons(pattern);
        Assert.assertNotNull(foundPeoples);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void getUserByInumTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.user = this.peopleRepository.createPerson(this.generateNewUser());
        String inum = this.user.getInum();
        System.out.println("==================");
        System.out.println("Get person" + inum);
        System.out.println("==================");
        this.user = this.peopleRepository.getPerson(inum);
        Assert.assertNotNull((Object)this.user);
        Assert.assertTrue((boolean)inum.equalsIgnoreCase(this.user.getInum()));
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void deleteUserTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.user = this.peopleRepository.createPerson(this.generateNewUser());
        String inum = this.user.getInum();
        System.out.println("==================");
        System.out.println("Delete person " + inum);
        System.out.println("==================");
        this.peopleRepository.deletePerson(inum);
        Assert.assertEquals(null, (Object)this.peopleRepository.getPerson(inum));
        Assert.assertTrue((boolean)inum.equalsIgnoreCase(this.user.getInum()));
        System.out.println("*******************");
        System.out.println("Done");
    }

    private GluuPersonApi generateNewUser() {
        int next1 = new Random().nextInt(100);
        int next2 = new Random().nextInt(50);
        String name = "User" + next1 + next2;
        GluuPersonApi person = new GluuPersonApi();
        person.setEmail(name + "@yahoo.fr");
        person.setUserName(name);
        person.setStatus(GluuStatus.ACTIVE);
        person.setPassword(name);
        person.setDisplayName(name.toUpperCase());
        person.setSurName(name);
        person.setGivenName(name);
        person.setCreationDate(new Date());
        return person;
    }
}

