/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.uma;

import java.util.List;
import java.util.Random;
import org.gluu.oxtrust.api.uma.UmaScopeRepository;
import org.gluu.oxtrust.api.users.PeopleRepository;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xdi.oxauth.model.uma.persistence.UmaScopeDescription;

public class UmaScopeTest {
    private UmaScopeRepository scopeRepository;
    private String inum;
    private String searchPattern = "scim";
    private UmaScopeDescription scope;
    private static boolean canRunOtherTest = false;

    @BeforeClass
    public static void testConnection() {
        try {
            PeopleRepository peopleRepositoryImpl = new PeopleRepository();
            peopleRepositoryImpl.searchPersons("user");
            canRunOtherTest = true;
        }
        catch (Exception e) {
            System.out.println("***********************");
            System.out.println("ERROR OCCURS: POSSIBLE CAUSES");
            System.out.println("1. MAKE SURE THE HOSTNAME DEFINE IN CONFIGURATION FILE IS RESOLVABLE");
            System.out.println("2. MAKE SURE THE CERTS FILE ARE IMPORTED IN JAVA KEY STORE");
            System.out.println("***********************");
        }
    }

    @Before
    public void setup() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.scopeRepository = new UmaScopeRepository();
    }

    @Test
    public void getAllUmaScopesTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("List uma scopes");
        System.out.println("==================");
        List<UmaScopeDescription> scopes = this.scopeRepository.getAllUmaScopes();
        Assert.assertNotNull(scopes);
        Assert.assertTrue((!scopes.isEmpty() ? 1 : 0) != 0);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void searchScopesTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Search uma scopes");
        System.out.println("==================");
        List<UmaScopeDescription> scopesFound = this.scopeRepository.searchUmaScopes(this.searchPattern, 10);
        Assert.assertNotNull(scopesFound);
        Assert.assertTrue((!scopesFound.isEmpty() ? 1 : 0) != 0);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void addUmaScopeTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Add new uma scope");
        System.out.println("==================");
        this.scope = this.scopeRepository.createUmaScope(this.generateNewUmaScope());
        Assert.assertNotNull((Object)this.scope);
        Assert.assertNotNull((Object)this.scope.getInum());
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void updateUmaScopeTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Update new uma scope");
        System.out.println("==================");
        this.scope = this.scopeRepository.createUmaScope(this.generateNewUmaScope());
        this.inum = this.scope.getInum();
        String displayName = "UpdatedDisplayName";
        this.scope.setDisplayName(displayName);
        this.scope = this.scopeRepository.updateScope(this.scope);
        Assert.assertNotNull((Object)this.scope);
        Assert.assertEquals((Object)this.inum, (Object)this.scope.getInum());
        Assert.assertEquals((Object)displayName, (Object)this.scope.getDisplayName());
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void getUmaScopeByInumTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Get uma scope by inum");
        System.out.println("==================");
        this.scope = this.scopeRepository.createUmaScope(this.generateNewUmaScope());
        this.inum = this.scope.getInum();
        this.scope = this.scopeRepository.getUmaScopeByInum(this.inum);
        Assert.assertNotNull((Object)this.scope);
        Assert.assertEquals((Object)this.inum, (Object)this.scope.getInum());
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void deleteUmaScopeTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.scope = this.scopeRepository.createUmaScope(this.generateNewUmaScope());
        this.inum = this.scope.getInum();
        this.scopeRepository.deleteUmaScope(this.inum);
        Assert.assertNull((Object)this.scopeRepository.getUmaScopeByInum(this.inum));
        System.out.println("*******************");
        System.out.println("Done");
    }

    private UmaScopeDescription generateNewUmaScope() {
        int next1 = new Random().nextInt(100);
        int next2 = new Random().nextInt(50);
        String name = "UmaScope" + next1 + next2;
        UmaScopeDescription scope = new UmaScopeDescription();
        scope.setDisplayName(name);
        scope.setDescription(name + "  " + name);
        scope.setId("https://gluu.gasmyr.com/identity/scim");
        return scope;
    }
}

