/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.uma;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.gluu.oxtrust.api.uma.UmaResourceRepository;
import org.gluu.oxtrust.api.users.PeopleRepository;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xdi.oxauth.model.uma.persistence.UmaResource;

public class UmaResourceTest {
    private UmaResourceRepository resourceRepository;
    private UmaResource resource;
    private String searchPattern = "scim";
    private String id;
    private static boolean canRunOtherTest = false;

    @BeforeClass
    public static void testConnection() {
        try {
            PeopleRepository peopleRepositoryImpl = new PeopleRepository();
            peopleRepositoryImpl.searchPersons("user");
            canRunOtherTest = true;
        }
        catch (Exception e) {
            System.out.println("***********************");
            System.out.println("ERROR OCCURS: POSSIBLE CAUSES");
            System.out.println("1. MAKE SURE THE HOSTNAME DEFINE IN CONFIGURATION FILE IS RESOLVABLE");
            System.out.println("2. MAKE SURE THE CERTS FILE ARE IMPORTED IN JAVA KEY STORE");
            System.out.println("***********************");
        }
    }

    @Before
    public void setup() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.resourceRepository = new UmaResourceRepository();
    }

    @Test
    public void getAllUmaResourcesTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("List uma resources");
        System.out.println("==================");
        List<UmaResource> resources = this.resourceRepository.getAllUmaResources();
        Assert.assertNotNull(resources);
        Assert.assertTrue((!resources.isEmpty() ? 1 : 0) != 0);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void searchUmaResourcesTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Search uma resources");
        System.out.println("==================");
        List<UmaResource> resources = this.resourceRepository.searchUmaResources(this.searchPattern, 100);
        Assert.assertNotNull(resources);
        Assert.assertTrue((!resources.isEmpty() ? 1 : 0) != 0);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void createUmaResourceTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Create uma resource ");
        System.out.println("==================");
        this.resource = this.resourceRepository.createUmaResource(this.generateUmaResource());
        Assert.assertNotNull((Object)this.resource);
        Assert.assertNotNull((Object)this.resource.getId());
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void updateUmaResourceTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Update uma resource ");
        System.out.println("==================");
        this.resource = this.resourceRepository.createUmaResource(this.generateUmaResource());
        this.id = this.resource.getId();
        this.resource = this.resourceRepository.updateUmaResource(this.resource);
        Assert.assertNotNull((Object)this.resource);
        Assert.assertEquals((Object)this.id, (Object)this.resource.getId());
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void deleteUmaResourceTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Delete uma resource ");
        System.out.println("==================");
        this.resource = this.resourceRepository.createUmaResource(this.generateUmaResource());
        this.id = this.resource.getId();
        this.resourceRepository.deleteUmaResource(this.id);
        Assert.assertNull((Object)this.resourceRepository.getUmaResourceById(this.id));
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void getUmaResourceTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Get uma resource ");
        System.out.println("==================");
        this.resource = this.resourceRepository.createUmaResource(this.generateUmaResource());
        this.id = this.resource.getId();
        this.resource = this.resourceRepository.getUmaResourceById(this.id);
        Assert.assertNotNull((Object)this.resource);
        Assert.assertEquals((Object)this.id, (Object)this.resource.getId());
        System.out.println("*******************");
        System.out.println("Done");
    }

    private UmaResource generateUmaResource() {
        int next1 = new Random().nextInt(100);
        int next2 = new Random().nextInt(50);
        String name = "New UmaResource" + next1 + next2;
        UmaResource umaResource = new UmaResource();
        umaResource.setName(name);
        umaResource.setDescription(name + " description");
        umaResource.setId(UUID.randomUUID().toString());
        return umaResource;
    }
}

