/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.openidconnect;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.gluu.oxtrust.api.openidconnect.SectorIdentifierRepository;
import org.gluu.oxtrust.model.OxAuthSectorIdentifier;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SectorIdentifierTest {
    private SectorIdentifierRepository sectorRepository;
    private OxAuthSectorIdentifier sector;
    private static String searchPattern = "-";
    private static boolean canRunOtherTest = false;
    private String oxID;

    @BeforeClass
    public static void testConnection() {
        try {
            SectorIdentifierRepository sectorRepository = new SectorIdentifierRepository();
            sectorRepository.searchSectorIdentifiers(searchPattern);
            canRunOtherTest = true;
        }
        catch (Exception e) {
            System.out.println("***********************");
            System.out.println("ERROR OCCURS: POSSIBLE CAUSES");
            System.out.println("1. MAKE SURE THE HOSTNAME DEFINE IN CONFIGURATION FILE IS RESOLVABLE");
            System.out.println("2. MAKE SURE THE CERTS FILE ARE IMPORTED IN JAVA KEY STORE");
            System.out.println("***********************");
        }
    }

    @Before
    public void setup() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.sectorRepository = new SectorIdentifierRepository();
    }

    @Test
    public void getAllSectorsTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("List sector identifiers");
        System.out.println("==================");
        List<OxAuthSectorIdentifier> sectors = this.sectorRepository.getAllSectorIdentifiers();
        Assert.assertNotNull(sectors);
        Assert.assertTrue((!sectors.isEmpty() ? 1 : 0) != 0);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void searchSectorsTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Search sector identifiers");
        System.out.println("==================");
        List<OxAuthSectorIdentifier> sectorsFound = this.sectorRepository.searchSectorIdentifiers(searchPattern);
        Assert.assertNotNull(sectorsFound);
        Assert.assertTrue((!sectorsFound.isEmpty() ? 1 : 0) != 0);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void addSectorTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Add new sector identifier");
        System.out.println("==================");
        this.sector = this.sectorRepository.createSector(this.generateNewSector());
        Assert.assertNotNull((Object)this.sector);
        Assert.assertNotNull((Object)this.sector.getId());
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void updateSectorTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Update sector identifier");
        System.out.println("==================");
        this.sector = this.sectorRepository.createSector(this.generateNewSector());
        List uris = this.sector.getRedirectUris();
        uris.add("https://updateuri.redirect.com");
        this.sector.setRedirectUris(uris);
        this.sector = this.sectorRepository.updateSector(this.sector);
        Assert.assertNotNull((Object)this.sector);
        Assert.assertNotNull((Object)this.sector.getId());
        Assert.assertNotNull((Object)this.sector.getRedirectUris());
        Assert.assertTrue((this.sector.getRedirectUris().size() == 2 ? 1 : 0) != 0);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void getSectorByIdTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Get sector identifier");
        System.out.println("==================");
        this.sector = this.sectorRepository.createSector(this.generateNewSector());
        this.oxID = this.sector.getId();
        this.sector = this.sectorRepository.getSectorIdentifier(this.oxID);
        Assert.assertNotNull((Object)this.sector);
        Assert.assertEquals((Object)this.oxID, (Object)this.sector.getId());
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void deleteSectorTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Delete sector identifier");
        System.out.println("==================");
        this.sector = this.sectorRepository.createSector(this.generateNewSector());
        this.oxID = this.sector.getId();
        this.sectorRepository.deleteSectorIdentifier(this.oxID);
        Assert.assertNull((Object)this.sectorRepository.getSectorIdentifier(this.oxID));
        System.out.println("*******************");
        System.out.println("Done");
    }

    private OxAuthSectorIdentifier generateNewSector() {
        OxAuthSectorIdentifier sector = new OxAuthSectorIdentifier();
        sector.setId(UUID.randomUUID().toString());
        sector.setSelected(true);
        ArrayList<String> redirectUris = new ArrayList<String>();
        redirectUris.add("https://simple.redirect.com" + new Random().nextInt(100));
        sector.setRedirectUris(redirectUris);
        return sector;
    }
}

