/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.openidconnect;

import java.util.List;
import org.gluu.oxtrust.api.BaseRepository;
import org.gluu.oxtrust.api.GluuOxAuthClient;
import org.gluu.oxtrust.api.proxy.OxAuthClientProxy;
import org.gluu.oxtrust.model.OxAuthScope;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

public class OxAuthClientRepository
extends BaseRepository {
    private String PATH = this.baseURI + this.PATH;
    private ResteasyClient client = new ResteasyClientBuilder().build();

    public List<GluuOxAuthClient> getAllClients() {
        ResteasyWebTarget target = this.client.target(this.PATH);
        OxAuthClientProxy client = (OxAuthClientProxy)target.proxy(OxAuthClientProxy.class);
        return client.getClients();
    }

    public List<GluuOxAuthClient> searchClients(String searchPattern, int size) {
        ResteasyWebTarget target = this.client.target(this.PATH);
        OxAuthClientProxy client = (OxAuthClientProxy)target.proxy(OxAuthClientProxy.class);
        return client.searchClients(searchPattern, size);
    }

    public List<OxAuthScope> getClientScopes(String inum) {
        ResteasyWebTarget target = this.client.target(this.PATH);
        OxAuthClientProxy client = (OxAuthClientProxy)target.proxy(OxAuthClientProxy.class);
        return client.getClientScopes(inum);
    }

    public void deleteClient(String inum) {
        ResteasyWebTarget target = this.client.target(this.PATH);
        OxAuthClientProxy client = (OxAuthClientProxy)target.proxy(OxAuthClientProxy.class);
        client.deleteClient(inum);
    }

    public GluuOxAuthClient addClient(GluuOxAuthClient gluuOxAuthClient) {
        ResteasyWebTarget target = this.client.target(this.PATH);
        OxAuthClientProxy client = (OxAuthClientProxy)target.proxy(OxAuthClientProxy.class);
        return client.createClient(gluuOxAuthClient);
    }

    public GluuOxAuthClient updateClient(GluuOxAuthClient gluuOxAuthClient) {
        ResteasyWebTarget target = this.client.target(this.PATH);
        OxAuthClientProxy client = (OxAuthClientProxy)target.proxy(OxAuthClientProxy.class);
        return client.updateClient(gluuOxAuthClient);
    }

    public GluuOxAuthClient getClientByInum(String inum) {
        ResteasyWebTarget target = this.client.target(this.PATH);
        OxAuthClientProxy client = (OxAuthClientProxy)target.proxy(OxAuthClientProxy.class);
        try {
            return client.getClient(inum);
        }
        catch (Exception e) {
            return null;
        }
    }
}

