/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.groups;

import java.util.List;
import java.util.Random;
import org.gluu.oxtrust.api.GluuGroupApi;
import org.gluu.oxtrust.api.GluuPersonApi;
import org.gluu.oxtrust.api.groups.GroupRepository;
import org.gluu.oxtrust.api.users.PeopleRepository;
import org.gluu.persist.model.base.GluuStatus;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GroupApiTest {
    private GluuGroupApi group;
    private GluuPersonApi user;
    private GroupRepository groupRepository;
    private PeopleRepository peopleRepository;
    private static boolean canRunOtherTest = false;

    @BeforeClass
    public static void testConnection() {
        try {
            GroupRepository groupRepository = new GroupRepository();
            groupRepository.searchGroup("admin", 1);
            canRunOtherTest = true;
        }
        catch (Exception e) {
            System.out.println("***********************");
            System.out.println("ERROR OCCURS: POSSIBLE CAUSES");
            System.out.println("1. MAKE SURE THE HOSTNAME DEFINE IN CONFIGURATION FILE IS RESOLVABLE");
            System.out.println("2. MAKE SURE THE CERTS FILE ARE IMPORTED IN JAVA KEY STORE");
            System.out.println("***********************");
        }
    }

    @Before
    public void setup() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.groupRepository = new GroupRepository();
    }

    @Test
    public void getAllGroupsTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("List groups");
        System.out.println("==================");
        List<GluuGroupApi> groups = this.groupRepository.getAllGroups();
        Assert.assertNotNull(groups);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void addGroupTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Add Group");
        System.out.println("==================");
        int sizeBefore = this.groupRepository.getAllGroups().size();
        this.group = this.groupRepository.createGroup(this.generateNewGroup());
        int sizeAfter = this.groupRepository.getAllGroups().size();
        Assert.assertNotNull((Object)this.group);
        Assert.assertNotNull((Object)this.group.getInum());
        Assert.assertTrue((sizeBefore + 1 == sizeAfter ? 1 : 0) != 0);
        System.out.println(this.group.toString());
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void updateGroupTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.group = this.groupRepository.createGroup(this.generateNewGroup());
        String displayName = "updated Display name";
        String inum = this.group.getInum();
        this.group.setDisplayName(displayName);
        System.out.println("=================Update group: " + inum);
        System.out.println("==================");
        this.group = this.groupRepository.updateGroup(this.group);
        Assert.assertEquals((Object)displayName, (Object)this.group.getDisplayName());
        Assert.assertEquals((Object)inum, (Object)this.group.getInum());
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void deleteGroupTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.group = this.groupRepository.createGroup(this.generateNewGroup());
        String inum = this.group.getInum();
        System.out.println("==================");
        System.out.println("Delete group  " + inum);
        System.out.println("==================");
        this.groupRepository.deleteGroup(this.group.getInum());
        Assert.assertEquals(null, (Object)this.groupRepository.getGroup(inum));
        Assert.assertTrue((boolean)inum.equalsIgnoreCase(this.group.getInum()));
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void searchGroupsTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Search groups");
        System.out.println("==================");
        String pattern = "user";
        List<GluuGroupApi> foundGroups = this.groupRepository.searchGroup(pattern, 10);
        Assert.assertNotNull(foundGroups);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void getGroupByInumTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.group = this.groupRepository.createGroup(this.generateNewGroup());
        String inum = this.group.getInum();
        System.out.println("==================");
        System.out.println("Get group by inum:" + inum);
        System.out.println("==================");
        this.group = this.groupRepository.getGroup(inum);
        Assert.assertNotNull((Object)this.group);
        Assert.assertTrue((boolean)inum.equalsIgnoreCase(this.group.getInum()));
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void getGroupMembersTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.group = this.groupRepository.createGroup(this.generateNewGroup());
        String inum = this.group.getInum();
        System.out.println("==================");
        System.out.println("Get group members:");
        System.out.println("==================");
        List<GluuPersonApi> foundMembers = this.groupRepository.getGroupMembers(inum);
        Assert.assertNotNull(foundMembers);
        Assert.assertTrue((foundMembers.size() == 0 ? 1 : 0) != 0);
        this.groupRepository.deleteGroup(inum);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void addGroupMemberTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.peopleRepository = new PeopleRepository();
        this.group = this.groupRepository.createGroup(this.generateNewGroup());
        this.user = this.peopleRepository.searchPersons("admin").get(0);
        String inum = this.group.getInum();
        System.out.println("==================");
        System.out.println("Add group member:" + this.group.getDisplayName());
        System.out.println("==================");
        this.groupRepository.addGroupMember(inum, this.user.getInum());
        List<GluuPersonApi> foundMembers = this.groupRepository.getGroupMembers(inum);
        Assert.assertNotNull(foundMembers);
        this.groupRepository.deleteGroup(inum);
        Assert.assertTrue((foundMembers.size() == 1 ? 1 : 0) != 0);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void removeGroupMemberTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.peopleRepository = new PeopleRepository();
        this.group = this.groupRepository.createGroup(this.generateNewGroup());
        this.user = this.peopleRepository.searchPersons("admin").get(0);
        String inum = this.group.getInum();
        System.out.println("==================");
        System.out.println("Remove group member:" + this.group.getDisplayName());
        System.out.println("==================");
        this.groupRepository.addGroupMember(inum, this.user.getInum());
        List<GluuPersonApi> foundMembers = this.groupRepository.getGroupMembers(inum);
        Assert.assertNotNull(foundMembers);
        this.groupRepository.deleteGroup(inum);
        Assert.assertTrue((foundMembers.size() == 1 ? 1 : 0) != 0);
        this.groupRepository.deleteGroupMember(inum, this.user.getInum());
        foundMembers = this.groupRepository.getGroupMembers(inum);
        Assert.assertNotNull(foundMembers);
        this.groupRepository.deleteGroup(inum);
        Assert.assertTrue((foundMembers.size() == 0 ? 1 : 0) != 0);
        System.out.println("*******************");
        System.out.println("Done");
    }

    private GluuGroupApi generateNewGroup() {
        int next1 = new Random().nextInt(100);
        int next2 = new Random().nextInt(50);
        String name = "GroupAddeByTest" + next1 + next2;
        GluuGroupApi group = new GluuGroupApi();
        group.setDescription("UDM Students");
        group.setDisplayName(name + next1 + next2);
        group.setStatus(GluuStatus.ACTIVE);
        group.setMembers(null);
        return group;
    }
}

