/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.api.attribute;

import java.util.List;
import java.util.Random;
import org.gluu.oxtrust.api.GluuAttributeApi;
import org.gluu.oxtrust.api.attribute.AttributeRepository;
import org.gluu.persist.model.base.GluuStatus;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xdi.model.GluuAttributeDataType;

public class AttributeApiTest {
    private AttributeRepository attributeRepository;
    private static String searchPattern = "city";
    private GluuAttributeApi attribute;
    private String inum;
    private static boolean canRunOtherTest = false;

    @BeforeClass
    public static void testConnection() {
        try {
            AttributeRepository attributeRepository = new AttributeRepository();
            attributeRepository.searchAttributes(searchPattern, 1);
            canRunOtherTest = true;
        }
        catch (Exception e) {
            System.out.println("***********************");
            System.out.println("ERROR OCCURS: POSSIBLE CAUSES");
            System.out.println("1. MAKE SURE THE HOSTNAME DEFINE IN CONFIGURATION FILE IS RESOLVABLE");
            System.out.println("2. MAKE SURE THE CERTS FILE ARE IMPORTED IN JAVA KEY STORE");
            System.out.println("***********************");
        }
    }

    @Before
    public void setup() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        this.attributeRepository = new AttributeRepository();
    }

    @Test
    public void getAllAttributesTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("List all attributes");
        System.out.println("==================");
        List<GluuAttributeApi> allAttributes = this.attributeRepository.getAllAttributes();
        Assert.assertNotNull(allAttributes);
        Assert.assertTrue((!allAttributes.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((allAttributes.size() > 1 ? 1 : 0) != 0);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void getAllActiveAttributesTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("List all actives attributes");
        System.out.println("==================");
        List<GluuAttributeApi> allActivesAttributes = this.attributeRepository.getAllActiveAttributes();
        Assert.assertNotNull(allActivesAttributes);
        Assert.assertTrue((!allActivesAttributes.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((allActivesAttributes.size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((allActivesAttributes.get(0).getStatus() == GluuStatus.ACTIVE ? 1 : 0) != 0);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void getAllInactiveAttributesTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("List all inactives attributes");
        System.out.println("==================");
        List<GluuAttributeApi> allInActivesAttributes = this.attributeRepository.getAllInActiveAttributes();
        Assert.assertNotNull(allInActivesAttributes);
        Assert.assertTrue((!allInActivesAttributes.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((allInActivesAttributes.size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((allInActivesAttributes.get(0).getStatus() == GluuStatus.INACTIVE ? 1 : 0) != 0);
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void searchAttributesTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Search Attributes");
        System.out.println("==================");
        List<GluuAttributeApi> attributesFound = this.attributeRepository.searchAttributes(searchPattern, 1);
        Assert.assertNotNull(attributesFound);
        Assert.assertTrue((!attributesFound.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((attributesFound.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void addAttributeTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Add new attribute");
        System.out.println("==================");
        this.attribute = this.attributeRepository.addAttribute(this.generatedNewAttribute());
        Assert.assertNotNull((Object)this.attribute);
        Assert.assertNotNull((Object)this.attribute.getInum());
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void updateAttributeTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Update attribute");
        System.out.println("==================");
        String description = "UpdatedDescription";
        this.attribute = this.attributeRepository.addAttribute(this.generatedNewAttribute());
        this.attribute.setDescription(description);
        this.attribute = this.attributeRepository.updateAttribute(this.attribute);
        Assert.assertNotNull((Object)this.attribute);
        Assert.assertNotNull((Object)this.attribute.getInum());
        Assert.assertEquals((Object)description, (Object)this.attribute.getDescription());
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void getAttributeByInumTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Get attribute by inum");
        System.out.println("==================");
        this.attribute = this.attributeRepository.addAttribute(this.generatedNewAttribute());
        this.inum = this.attribute.getInum();
        this.attribute = this.attributeRepository.getAttributeByInum(this.inum);
        Assert.assertNotNull((Object)this.attribute);
        Assert.assertEquals((Object)this.inum, (Object)this.attribute.getInum());
        System.out.println("*******************");
        System.out.println("Done");
    }

    @Test
    public void deleteAttributeTest() {
        Assume.assumeTrue((boolean)canRunOtherTest);
        System.out.println("==================");
        System.out.println("Update attribute");
        System.out.println("==================");
        this.attribute = this.attributeRepository.addAttribute(this.generatedNewAttribute());
        this.inum = this.attribute.getInum();
        this.attributeRepository.deleteAttribute(this.inum);
        Assert.assertNull((Object)this.attributeRepository.getAttributeByInum(this.inum));
        System.out.println("*******************");
        System.out.println("Done");
    }

    private GluuAttributeApi generatedNewAttribute() {
        int next1 = new Random().nextInt(100);
        int next2 = new Random().nextInt(50);
        GluuAttributeApi gluuAttributeApi = new GluuAttributeApi();
        String displayName = "AtrributeAddByTest" + next1 + next2;
        gluuAttributeApi.setDescription("My new Attribute");
        gluuAttributeApi.setDisplayName(displayName);
        gluuAttributeApi.setDataType(GluuAttributeDataType.STRING);
        gluuAttributeApi.setStatus(GluuStatus.ACTIVE);
        gluuAttributeApi.setName("kudiaId");
        gluuAttributeApi.setOrigin("gluuPerson");
        return gluuAttributeApi;
    }
}

