/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxpush;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.xdi.oxpush.AuthenticationProcess;
import org.xdi.oxpush.AuthenticationStatus;
import org.xdi.oxpush.DeploymentStatus;
import org.xdi.oxpush.OxPushError;
import org.xdi.oxpush.PairingProcess;
import org.xdi.oxpush.PairingStatus;

public class OxPushClient {
    private final HttpClient httpClient;
    private String baseUri;
    private static ResponseHandler<JSONObject> responseHandler = new ResponseHandler<JSONObject>(){

        public JSONObject handleResponse(HttpResponse httpResponse) throws IOException {
            JSONObject result = null;
            if (httpResponse != null) {
                StatusLine statusLine = httpResponse.getStatusLine();
                switch (statusLine.getStatusCode()) {
                    case 200: {
                        HttpEntity entity = httpResponse.getEntity();
                        if (entity == null) break;
                        String json = EntityUtils.toString((HttpEntity)entity);
                        try {
                            result = (JSONObject)new JSONTokener(json).nextValue();
                            break;
                        }
                        catch (JSONException ex) {
                            throw new ClientProtocolException("Failed to parse JSON", (Throwable)ex);
                        }
                    }
                    default: {
                        throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                    }
                }
            }
            return result;
        }
    };

    public OxPushClient(String baseUri) {
        this.baseUri = baseUri;
        this.httpClient = new DefaultHttpClient();
    }

    public DeploymentStatus getDeploymentStatus(String deploymentId) throws OxPushError {
        String requestUri = String.format("%s/%s/%s", this.baseUri, "check_deployment", deploymentId);
        try {
            JSONObject json = this.executeGet(requestUri);
            return DeploymentStatus.fromJSON(json);
        }
        catch (Exception ex) {
            throw new OxPushError("Failed to determine deployment status", ex);
        }
    }

    public PairingProcess pair(String applicationName, String userName) throws OxPushError {
        String requestUri = String.format("%s/%s/%s/%s", this.baseUri, "initialize_pairing", applicationName, userName);
        try {
            JSONObject json = this.executeGet(requestUri);
            return PairingProcess.fromJSON(json);
        }
        catch (Exception ex) {
            throw new OxPushError("Failed to initialize pairing process", ex);
        }
    }

    public PairingStatus getPairingStatus(String pairingId) throws OxPushError {
        String requestUri = String.format("%s/%s/%s", this.baseUri, "check_pairing", pairingId);
        try {
            JSONObject json = this.executeGet(requestUri);
            return PairingStatus.fromJSON(json);
        }
        catch (Exception ex) {
            throw new OxPushError("Failed to determine pairing status", ex);
        }
    }

    public AuthenticationProcess authenticate(String deploymentId, String userName) throws OxPushError {
        String requestUri = String.format("%s/%s/%s/%s", this.baseUri, "authenticate", deploymentId, userName);
        try {
            JSONObject json = this.executeGet(requestUri);
            return AuthenticationProcess.fromJSON(json);
        }
        catch (Exception ex) {
            throw new OxPushError("Failed to initialize authentication process", ex);
        }
    }

    public AuthenticationStatus getAuthenticationStatus(String authenticationId) throws OxPushError {
        String requestUri = String.format("%s/%s/%s", this.baseUri, "check_authentication", authenticationId);
        try {
            JSONObject json = this.executeGet(requestUri);
            return AuthenticationStatus.fromJSON(json);
        }
        catch (Exception ex) {
            throw new OxPushError("Failed to determine authentication status", ex);
        }
    }

    private JSONObject executeGet(String endpointUri) throws Exception {
        HttpGet httpGet = new HttpGet(endpointUri);
        return (JSONObject)this.httpClient.execute((HttpUriRequest)httpGet, responseHandler);
    }
}

