/*
 * Decompiled with CFR 0.152.
 */
import com.google.common.collect.Lists;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.nicholaswilliams.java.licensing.exception.InvalidLicenseException;
import org.testng.annotations.Test;
import org.xdi.oxd.license.client.js.LicenseMetadata;
import org.xdi.oxd.license.client.js.Product;
import org.xdi.oxd.license.validator.LicenseValidator;

public class LicenseValidatorMetadataTest {
    @Test
    public void notExpired() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.add(5, 10);
        LicenseValidator.validateMetadata((LicenseMetadata)this.testMetadata(), (Product)Product.OXD, (Date)new Date());
        LicenseValidator.validateMetadata((LicenseMetadata)this.testMetadata(), (Product)Product.OXD, (Date)currentDate.getTime());
    }

    @Test(expectedExceptions={InvalidLicenseException.class})
    public void expired() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.add(5, 32);
        LicenseValidator.validateMetadata((LicenseMetadata)this.testMetadata(), (Product)Product.OXD, (Date)currentDate.getTime());
    }

    @Test(expectedExceptions={InvalidLicenseException.class})
    public void notValidProduct() {
        LicenseValidator.validateMetadata((LicenseMetadata)this.testMetadata(), (Product)Product.CLUSTER_MANAGER, (Date)new Date());
    }

    private LicenseMetadata testMetadata() {
        Date creationDate = new Date();
        Calendar expiration = Calendar.getInstance();
        expiration.add(2, 1);
        LicenseMetadata metadata = new LicenseMetadata();
        metadata.setActive(Boolean.valueOf(true));
        metadata.setCreationDate(creationDate);
        metadata.setExpirationDate(expiration.getTime());
        metadata.setLicenseId("test_id");
        metadata.setLicenseCountLimit(9999);
        metadata.setProducts((List)Lists.newArrayList((Object[])new String[]{"oxd"}));
        return metadata;
    }
}

