/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import java.util.Date;
import net.nicholaswilliams.java.licensing.exception.InvalidLicenseException;
import org.testng.annotations.Test;
import org.xdi.oxd.license.client.js.LicenseMetadata;
import org.xdi.oxd.license.client.js.Product;
import org.xdi.oxd.license.validator.LicenseValidator;

public class LicenseValidatorMetadataTest {
    @Test
    public void notExpired() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.add(5, 10);
        LicenseValidator.validateMetadata((LicenseMetadata)this.testMetadata(), (Product)Product.OXD, (Date)new Date());
        LicenseValidator.validateMetadata((LicenseMetadata)this.testMetadata(), (Product)Product.OXD, (Date)currentDate.getTime());
    }

    @Test(expectedExceptions={InvalidLicenseException.class})
    public void expired() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.add(5, 32);
        LicenseValidator.validateMetadata((LicenseMetadata)this.testMetadata(), (Product)Product.OXD, (Date)currentDate.getTime());
    }

    @Test(expectedExceptions={InvalidLicenseException.class})
    public void notValidProduct() {
        LicenseValidator.validateMetadata((LicenseMetadata)this.testMetadata(), (Product)Product.DE, (Date)new Date());
    }

    private LicenseMetadata testMetadata() {
        Date creationDate = new Date();
        Calendar expiration = Calendar.getInstance();
        expiration.add(2, 1);
        LicenseMetadata metadata = new LicenseMetadata();
        metadata.setActive(Boolean.valueOf(true));
        metadata.setCreationDate(creationDate);
        metadata.setExpirationDate(expiration.getTime());
        metadata.setLicenseId("test_id");
        metadata.setLicenseCountLimit(9999);
        metadata.setProduct("oxd");
        return metadata;
    }
}

