package org.xdi.oxd.license.client.js;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Yuriy Zabrovarnyy
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class StatisticUpdateRequest {

    public static final String LICENSE_ID = "license_id";
    public static final String CLIENT_ID = "client_id";
    public static final String OXD_ID = "oxd_id";
    public static final String CLIENT_NAME = "client_name";
    public static final String MAC_ADDRESS = "mac_address";
    public static final String IS_CLIENT_LOCAL = "is_client_local";

    public static enum Type {
        CLIENT
    }

    @JsonProperty(value = "type")
    private Type type;
    @JsonProperty(value = LICENSE_ID)
    private String licenseId;
    @JsonProperty(value = "properties")
    private Map<String, String> properties = new HashMap<>();
    @JsonProperty(value = "app_metadata")
    private AppMetadata appMetadata;


    public static StatisticUpdateRequest clientUpdate(String licenseId, String clientId, String oxdId, String clientName, String macAddress, boolean isClientLocal) {
        StatisticUpdateRequest request = new StatisticUpdateRequest();
        request.setType(Type.CLIENT);
        request.getProperties().put(LICENSE_ID, licenseId);
        request.getProperties().put(CLIENT_ID, clientId);
        request.getProperties().put(OXD_ID, oxdId);
        request.getProperties().put(CLIENT_NAME, clientName);
        request.getProperties().put(MAC_ADDRESS, macAddress);
        request.getProperties().put(IS_CLIENT_LOCAL, Boolean.toString(isClientLocal));
        return request;
    }

    public String getLicenseId() {
        return licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Map<String, String> getProperties() {
        return properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public AppMetadata getAppMetadata() {
        return appMetadata;
    }

    public void setAppMetadata(AppMetadata appMetadata) {
        this.appMetadata = appMetadata;
    }

    @Override
    public String toString() {
        return "StatisticUpdateRequest{" +
                "type=" + type +
                ", licenseId='" + licenseId + '\'' +
                ", properties=" + properties +
                ", appMetadata=" + appMetadata +
                '}';
    }
}
