/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.license.client.manual;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import junit.framework.Assert;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jboss.resteasy.client.ClientExecutor;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.client.uma.UmaTokenService;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.uma.UmaMetadata;
import org.xdi.oxauth.model.uma.UmaTokenResponse;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxd.license.client.ClientUtils;
import org.xdi.oxd.license.client.GenerateWS;
import org.xdi.oxd.license.client.Jackson;
import org.xdi.oxd.license.client.LicenseClient;
import org.xdi.oxd.license.client.MetadataWS;
import org.xdi.oxd.license.client.js.LicenseIdItem;
import org.xdi.oxd.license.client.js.LicenseMetadata;
import org.xdi.oxd.license.client.js.Product;

public class RequestLicenseId {
    public static final String OP_HOST = "https://accounts.gluu.org";
    public static final String OP_WELL_KNOWN = "https://accounts.gluu.org/.well-known/openid-configuration";
    public static final String OP_UMA_WELL_KNOWN = "https://accounts.gluu.org/.well-known/uma2-configuration";
    public static final String CLIENT_ID = "";
    public static final String CLIENT_SECRET = "";
    public static final String LICENSE_SERVER_ENDPOINT = "https://devlicense.gluu.org/oxLicense";
    public static final String REQUIRED_SCOPE = "licenseApiAccess";

    public static void main(String[] args) throws Exception {
        String ticket = null;
        try {
            List list = RequestLicenseId.generateWS().generateLicenseId(3, "Bearer fake_rpt", RequestLicenseId.testMetadata());
        }
        catch (Exception e) {
            System.out.println(e);
        }
        Preconditions.checkState((boolean)StringUtils.isNotBlank(ticket));
        String rpt = RequestLicenseId.obtainRpt(ticket);
        List list = RequestLicenseId.generateWS().generateLicenseId(3, "Bearer " + rpt, RequestLicenseId.testMetadata());
        Assert.assertTrue((!list.isEmpty() ? 1 : 0) != 0);
        System.out.println("Generated License IDs:");
        System.out.println(list);
        LicenseIdItem firstLicenseId = (LicenseIdItem)list.get(0);
        System.out.println("First license id: " + firstLicenseId.getLicenseId());
        LicenseMetadata metadata = RequestLicenseId.metadataWS().get(firstLicenseId.getLicenseId());
        System.out.println(Jackson.asJsonSilently((Object)metadata));
        System.out.println("Metadata of license id (" + firstLicenseId.getLicenseId() + ") : " + metadata);
        Assert.assertTrue((boolean)((String)metadata.getProducts().get(0)).equals(Product.OXD.getValue()));
        metadata.setProducts((List)Lists.newArrayList((Object[])new String[]{Product.API_GATEWAY.getValue()}));
        Response update = RequestLicenseId.metadataWS().update("Bearer " + rpt, metadata);
        Assert.assertTrue((update.getStatus() == 200 ? 1 : 0) != 0);
        LicenseMetadata updatedMetadata = RequestLicenseId.metadataWS().get(firstLicenseId.getLicenseId());
        System.out.println("Updated metadata of license id (" + firstLicenseId.getLicenseId() + ") : " + updatedMetadata);
        Assert.assertTrue((boolean)((String)updatedMetadata.getProducts().get(0)).equals(Product.API_GATEWAY.getValue()));
    }

    private static GenerateWS generateWS() {
        return LicenseClient.generateWs((String)LICENSE_SERVER_ENDPOINT, (ClientExecutor)ClientUtils.executor());
    }

    private static MetadataWS metadataWS() {
        return LicenseClient.metadataWs((String)LICENSE_SERVER_ENDPOINT, (ClientExecutor)ClientUtils.executor());
    }

    private static LicenseMetadata testMetadata() {
        Calendar expirationDate = Calendar.getInstance();
        expirationDate.add(1, 1);
        LicenseMetadata metadata = new LicenseMetadata();
        metadata.setProducts((List)Lists.newArrayList((Object[])new String[]{Product.OXD.getValue()}));
        metadata.setLicenseCountLimit(9999);
        metadata.setCreationDate(new Date());
        metadata.setExpirationDate(expirationDate.getTime());
        return metadata;
    }

    public static String encodeCredentials(String username, String password) throws UnsupportedEncodingException {
        return Base64.encodeBase64String((byte[])Util.getBytes((String)(username + ":" + password)));
    }

    private static String obtainRpt(String ticket) throws UnsupportedEncodingException {
        UmaMetadata umaConfiguration = UmaClientFactory.instance().createMetadataService(OP_UMA_WELL_KNOWN, ClientUtils.executor()).getMetadata();
        UmaTokenService tokenService = UmaClientFactory.instance().createTokenService(umaConfiguration, ClientUtils.executor());
        UmaTokenResponse rpt = tokenService.requestRpt("Basic " + RequestLicenseId.encodeCredentials("", ""), GrantType.OXAUTH_UMA_TICKET.getValue(), ticket, null, null, null, null, null);
        System.out.println(rpt);
        return rpt.getAccessToken();
    }
}

