/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.license.client;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import junit.framework.Assert;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.client.uma.CreateRptService;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.model.uma.UmaConfiguration;
import org.xdi.oxd.license.client.GenerateWS;
import org.xdi.oxd.license.client.LicenseClient;
import org.xdi.oxd.license.client.data.LicenseResponse;
import org.xdi.oxd.license.client.js.LicenseMetadata;

public class LicenseClientTest {
    @Parameters(value={"licenseServerEndpoint"})
    @Test(enabled=false)
    public void generateLicense(String licenseServerEndpoint) {
        GenerateWS generateWS = LicenseClient.generateWs((String)licenseServerEndpoint);
        List generatedLicense = generateWS.generatePost("id", "mac_address");
        Assert.assertTrue((generatedLicense != null && !generatedLicense.isEmpty() && !Strings.isNullOrEmpty((String)((LicenseResponse)generatedLicense.get(0)).getEncodedLicense()) ? 1 : 0) != 0);
        System.out.println(((LicenseResponse)generatedLicense.get(0)).getEncodedLicense());
    }

    @Parameters(value={"licenseServerEndpoint"})
    @Test(enabled=false)
    public void generateLicenseIds(String licenseServerEndpoint, String umaDiscoveryEndpoint) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        GenerateWS generateWS = LicenseClient.generateWs((String)licenseServerEndpoint);
        UmaConfiguration umaConfiguration = UmaClientFactory.instance().createMetaDataConfigurationService(umaDiscoveryEndpoint, (ClientExecutor)LicenseClientTest.trustAllExecutor()).getMetadataConfiguration();
        CreateRptService rptService = UmaClientFactory.instance().createRequesterPermissionTokenService(umaConfiguration, (ClientExecutor)LicenseClientTest.trustAllExecutor());
        String rpt = rptService.createRPT("aat", "https://idp.gluu.org").getRpt();
        List list = generateWS.generateLicenseId(5, "Bearer " + rpt, LicenseClientTest.testMetadata());
        Assert.assertTrue((!list.isEmpty() ? 1 : 0) != 0);
        System.out.println(list);
    }

    private static LicenseMetadata testMetadata() {
        LicenseMetadata metadata = new LicenseMetadata();
        metadata.setProducts((List)Lists.newArrayList((Object[])new String[]{"oxd"}));
        metadata.setLicenseCountLimit(9999);
        metadata.setCreationDate(new Date());
        return metadata;
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        LicenseClientTest test = new LicenseClientTest();
        test.generateLicenseIds("https://license.gluu.org/oxLicense", "https://idp.gluu.org/.well-known/uma-configuration");
    }

    public static ApacheHttpClient4Executor trustAllExecutor() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        return new ApacheHttpClient4Executor(LicenseClientTest.createHttpClientTrustAll());
    }

    public static HttpClient createHttpClientTrustAll() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        SSLSocketFactory sf = new SSLSocketFactory(new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }, new X509HostnameVerifier(){

            public void verify(String host, SSLSocket ssl) throws IOException {
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            }

            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)sf));
        PoolingClientConnectionManager ccm = new PoolingClientConnectionManager(registry);
        return new DefaultHttpClient((ClientConnectionManager)ccm);
    }
}

