package org.xdi.oxd.license.client.js.event;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.oxd.license.client.js.HasCreationDate;
import org.xdi.oxd.license.client.js.UnixTimestampDeserializer;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Yuriy Zabrovarnyy
 */
@LdapEntry
@LdapObjectClass(values = {"top", "oxLicenseIdStatistic"})
public class LdapLicenseGeneratedEvent implements Serializable, HasCreationDate {

    @LdapDN
    private String dn;
    @LdapAttribute(name = "uniqueIdentifier")
    private String id;
    @JsonDeserialize(using = UnixTimestampDeserializer.class)
    @LdapAttribute(name = "oxCreationDate")
    private Date creationDate;
    @LdapAttribute(name = "oxMacAddress")
    private String macAddress;

    public String getDn() {
        return dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getMacAddress() {
        return macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    @Override
    public String toString() {
        return "LdapLicenseGeneratedEvent{" +
                "dn='" + dn + '\'' +
                ", id='" + id + '\'' +
                ", creationDate=" + creationDate +
                ", macAddress='" + macAddress + '\'' +
                '}';
    }
}
