/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.rp.client;

import java.io.IOException;
import org.xdi.oxd.client.CommandClient;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.params.CheckIdTokenParams;
import org.xdi.oxd.common.params.GetAuthorizationUrlParams;
import org.xdi.oxd.common.params.IParams;
import org.xdi.oxd.common.params.RegisterSiteParams;
import org.xdi.oxd.common.response.CheckIdTokenResponse;
import org.xdi.oxd.common.response.GetAuthorizationUrlResponse;
import org.xdi.oxd.common.response.RegisterSiteResponse;
import org.xdi.oxd.rp.client.RpClient;

public class RpSocketClient
implements RpClient {
    private CommandClient client;
    private RegisterSiteResponse registrationDetails;

    protected RpSocketClient(String host, int port) {
        try {
            this.client = new CommandClient(host, port);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to open connection to " + host + ":" + port, e);
        }
    }

    public static RpSocketClient newSocketClient(String host, int port) {
        return new RpSocketClient(host, port);
    }

    @Override
    public RpClient register(String authorizationUrl) {
        RegisterSiteParams params = new RegisterSiteParams();
        params.setAuthorizationRedirectUri(authorizationUrl);
        return this.register(params);
    }

    @Override
    public RpClient register(RegisterSiteParams params) {
        Command command = new Command(CommandType.REGISTER_SITE);
        command.setParamsObject((IParams)params);
        this.registrationDetails = (RegisterSiteResponse)this.client.send(command).dataAsResponse(RegisterSiteResponse.class);
        return this;
    }

    @Override
    public RegisterSiteResponse getRegistrationDetails() {
        return this.registrationDetails;
    }

    @Override
    public String getOxdId() {
        return this.registrationDetails.getOxdId();
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public String getAuthorizationUrl() {
        GetAuthorizationUrlParams commandParams = new GetAuthorizationUrlParams();
        commandParams.setOxdId(this.getOxdId());
        Command command = new Command(CommandType.GET_AUTHORIZATION_URL);
        command.setParamsObject((IParams)commandParams);
        GetAuthorizationUrlResponse resp = (GetAuthorizationUrlResponse)this.client.send(command).dataAsResponse(GetAuthorizationUrlResponse.class);
        return resp.getAuthorizationUrl();
    }

    @Override
    public CheckIdTokenResponse validateIdToken(String idToken) {
        CheckIdTokenParams params = new CheckIdTokenParams();
        params.setOxdId(this.getOxdId());
        params.setIdToken(idToken);
        Command checkIdTokenCommand = new Command(CommandType.CHECK_ID_TOKEN);
        checkIdTokenCommand.setParamsObject((IParams)params);
        return (CheckIdTokenResponse)this.client.send(checkIdTokenCommand).dataAsResponse(CheckIdTokenResponse.class);
    }
}

