/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.rp.client;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxd.rp.client.HrefDetails;

public class RpClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RpClientUtils.class);

    private RpClientUtils() {
    }

    public static HrefDetails parseHref(String href) {
        int codeIndex = RpClientUtils.startIndex(href, "code");
        int accessTokenIndex = RpClientUtils.startIndex(href, "access_token");
        int idTokenIndex = RpClientUtils.startIndex(href, "id_token");
        HrefDetails hrefDetails = new HrefDetails();
        if (codeIndex != -1) {
            hrefDetails.setCode(RpClientUtils.substring(href, codeIndex));
        }
        if (accessTokenIndex != -1) {
            hrefDetails.setAccessToken(RpClientUtils.substring(href, accessTokenIndex));
        }
        if (idTokenIndex != -1) {
            hrefDetails.setIdToken(RpClientUtils.substring(href, idTokenIndex));
        }
        return hrefDetails;
    }

    private static String substring(String href, int startIndex) {
        try {
            int endIndex = href.indexOf("&", startIndex);
            String result = endIndex != -1 ? href.substring(startIndex, endIndex) : href.substring(startIndex);
            return result.trim();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static int startIndex(String href, String toSearch) {
        int index = href.indexOf("&" + toSearch + "=");
        if (index == -1) {
            index = href.indexOf("#" + toSearch + "=");
        }
        return index += ("&" + toSearch + "=").length();
    }
}

