/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.rs.protect.resteasy;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.client.uma.UmaMetadataService;
import org.xdi.oxauth.client.uma.UmaPermissionService;
import org.xdi.oxauth.client.uma.UmaResourceService;
import org.xdi.oxauth.client.uma.UmaRptIntrospectionService;
import org.xdi.oxauth.model.uma.UmaMetadata;

public class ServiceProvider {
    public static final String WELL_KNOWN_UMA_PATH = "/.well-known/uma2-configuration";
    private static final Logger LOG = Logger.getLogger(ServiceProvider.class);
    private final String opHost;
    private final ClientExecutor clientExecutor;
    private UmaMetadata umaMetadata = null;
    private UmaMetadataService metadataService = null;
    private UmaResourceService resourceService = null;
    private UmaPermissionService permissionService;
    private UmaRptIntrospectionService rptIntrospectionService;

    public ServiceProvider(String opHost) {
        this(opHost, true);
    }

    public ServiceProvider(String opHost, boolean trustAll) {
        this(opHost, trustAll ? new ApacheHttpClient4Executor(ServiceProvider.createHttpClientTrustAll()) : new ApacheHttpClient4Executor());
    }

    public ServiceProvider(String opHost, ClientExecutor clientExecutor) {
        this.opHost = opHost;
        this.clientExecutor = clientExecutor;
    }

    public synchronized UmaRptIntrospectionService getRptIntrospectionService() {
        if (this.rptIntrospectionService == null) {
            this.rptIntrospectionService = UmaClientFactory.instance().createRptStatusService(this.umaMetadata, this.clientExecutor);
        }
        return this.rptIntrospectionService;
    }

    public synchronized UmaMetadataService getMetadataService() {
        if (this.metadataService == null) {
            this.metadataService = UmaClientFactory.instance().createMetadataService(this.opHost + WELL_KNOWN_UMA_PATH, this.clientExecutor);
        }
        return this.metadataService;
    }

    public synchronized UmaMetadata getUmaMetadata() {
        if (this.umaMetadata == null) {
            this.umaMetadata = this.getMetadataService().getMetadata();
            LOG.trace("UMA discovery:" + this.umaMetadata);
        }
        return this.umaMetadata;
    }

    public synchronized UmaResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = UmaClientFactory.instance().createResourceService(this.getUmaMetadata(), this.clientExecutor);
        }
        return this.resourceService;
    }

    public synchronized UmaPermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = UmaClientFactory.instance().createPermissionService(this.getUmaMetadata(), this.clientExecutor);
        }
        return this.permissionService;
    }

    public String getOpHost() {
        return this.opHost;
    }

    public String opHostWithoutProtocol() {
        if (StringUtils.contains(this.opHost, "//")) {
            return StringUtils.substringAfter(this.opHost, "//");
        }
        return this.opHost;
    }

    public ClientExecutor getClientExecutor() {
        return this.clientExecutor;
    }

    public static HttpClient createHttpClientTrustAll() {
        try {
            SSLSocketFactory sf = new SSLSocketFactory(new TrustStrategy(){

                @Override
                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }, new X509HostnameVerifier(){

                @Override
                public void verify(String host, SSLSocket ssl) throws IOException {
                }

                @Override
                public void verify(String host, X509Certificate cert) throws SSLException {
                }

                @Override
                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                }

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", 80, PlainSocketFactory.getSocketFactory()));
            registry.register(new Scheme("https", 443, sf));
            SingleClientConnManager ccm = new SingleClientConnManager(registry);
            return new DefaultHttpClient(ccm);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

