/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.rs.protect.resteasy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.xdi.oxauth.model.uma.JsonLogicNodeParser;
import org.xdi.oxauth.model.uma.UmaResource;
import org.xdi.oxauth.model.uma.UmaResourceResponse;
import org.xdi.oxd.rs.protect.Condition;
import org.xdi.oxd.rs.protect.RsProtector;
import org.xdi.oxd.rs.protect.RsResource;
import org.xdi.oxd.rs.protect.resteasy.Key;
import org.xdi.oxd.rs.protect.resteasy.PatProvider;
import org.xdi.oxd.rs.protect.resteasy.ServiceProvider;

public class ResourceRegistrar {
    private static final Logger LOG = Logger.getLogger(ResourceRegistrar.class);
    private final Map<Key, RsResource> resourceMap = Maps.newHashMap();
    private final Map<Key, String> idMap = Maps.newHashMap();
    private final PatProvider patProvider;
    private final ServiceProvider serviceProvider;

    public ResourceRegistrar(PatProvider patProvider, ServiceProvider serviceProvider) {
        this.patProvider = patProvider;
        this.serviceProvider = serviceProvider;
    }

    public RsProtector getProtector() {
        return new RsProtector(Lists.newArrayList(this.resourceMap.values()));
    }

    public RsResource getRsResource(Key key) {
        return this.resourceMap.get(key);
    }

    public void register(Collection<RsResource> resources) {
        Preconditions.checkNotNull(resources);
        for (RsResource resource : resources) {
            this.register(resource);
        }
    }

    public Key getKey(String path, String httpMethod) {
        if (Strings.isNullOrEmpty(path) || Strings.isNullOrEmpty(httpMethod)) {
            return null;
        }
        String id = this.idMap.get(new Key(path, Lists.newArrayList(httpMethod)));
        if (id != null) {
            return new Key(path, Lists.newArrayList(httpMethod));
        }
        for (Key key : this.idMap.keySet()) {
            if (!path.startsWith(key.getPath()) || !key.getHttpMethods().contains(httpMethod)) continue;
            return key;
        }
        return null;
    }

    public String getResourceSetId(Key key) {
        return key != null ? this.idMap.get(key) : null;
    }

    public String getResourceSetId(String path, String httpMethod) {
        return this.getResourceSetId(this.getKey(path, httpMethod));
    }

    private void register(RsResource rsResource) {
        try {
            for (Condition condition : rsResource.getConditions()) {
                Key key = new Key(rsResource.getPath(), condition.getHttpMethods());
                UmaResource resource = new UmaResource();
                resource.setName(key.getResourceName());
                if (condition.getScopeExpression() != null && JsonLogicNodeParser.isNodeValid(condition.getScopeExpression().toString())) {
                    resource.setScopeExpression(condition.getScopeExpression().toString());
                    resource.setScopes(JsonLogicNodeParser.parseNode(condition.getScopeExpression().toString()).getData());
                } else {
                    resource.setScopes(condition.getScopes());
                }
                UmaResourceResponse resourceResponse = this.serviceProvider.getResourceService().addResource("Bearer " + this.patProvider.getPatToken(), resource);
                Preconditions.checkNotNull(resourceResponse.getId(), "Resource ID can not be null.");
                this.resourceMap.put(key, rsResource);
                this.idMap.put(key, resourceResponse.getId());
                LOG.debug("Registered resource, path: " + key.getPath() + ", http methods: " + condition.getHttpMethods() + ", id: " + resourceResponse.getId());
            }
        }
        catch (ClientResponseFailure ex) {
            LOG.error(ex.getMessage(), ex);
            throw ex;
        }
    }

    public void putRegisteredResource(RsResource resource, String idOfResourceOnAuthorizationServer) {
        for (Condition condition : resource.getConditions()) {
            Key key = new Key(resource.getPath(), condition.getHttpMethods());
            this.resourceMap.put(key, resource);
            this.idMap.put(key, idOfResourceOnAuthorizationServer);
            LOG.debug("Put registered resource, path: " + key.getPath() + ", http methods: " + condition.getHttpMethods() + ", id: " + idOfResourceOnAuthorizationServer);
        }
    }

    public PatProvider getPatProvider() {
        return this.patProvider;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public Map<Key, RsResource> getResourceMapCopy() {
        return Maps.newHashMap(this.resourceMap);
    }

    public Map<Key, String> getIdMapCopy() {
        return Maps.newHashMap(this.idMap);
    }
}

