/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.rs.protect;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.xdi.oxd.rs.protect.Condition;
import org.xdi.oxd.rs.protect.RsResource;

public class ResourceValidator {
    private ResourceValidator() {
    }

    public static boolean isHttpMethodUniqueInPath(List<RsResource> resources) {
        if (resources == null || resources.isEmpty()) {
            return true;
        }
        HashMap pathToHttpMethod = Maps.newHashMap();
        for (RsResource resource : resources) {
            if (!pathToHttpMethod.containsKey(resource.getPath())) {
                pathToHttpMethod.put(resource.getPath(), Lists.newArrayList());
            }
            List httpMethods = (List)pathToHttpMethod.get(resource.getPath());
            if (resource.getConditions() == null) continue;
            for (Condition condition : resource.getConditions()) {
                if (condition.getHttpMethods() == null) continue;
                for (String httpMethod : condition.getHttpMethods()) {
                    if (httpMethods.contains(httpMethod)) {
                        return false;
                    }
                    httpMethods.add(httpMethod);
                }
            }
        }
        return true;
    }
}

