/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.rs.protect;

import java.io.IOException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jackson {
    public static final String UTF8 = "UTF-8";
    private static final Logger LOG = LoggerFactory.getLogger(Jackson.class);

    public static String asJson(Object p_object) throws IOException {
        ObjectMapper mapper = Jackson.createJsonMapper().configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, false);
        return mapper.writeValueAsString(p_object);
    }

    public static ObjectMapper createJsonMapper() {
        return JacksonMapperHolder.MAPPER;
    }

    public static String asPrettyJson(Object p_object) throws IOException {
        ObjectMapper mapper = Jackson.createJsonMapper().configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, false);
        ObjectWriter writer = mapper.writer().withDefaultPrettyPrinter();
        return writer.writeValueAsString(p_object);
    }

    public static String asJsonSilently(Object p_object) {
        try {
            return Jackson.asPrettyJson(p_object);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), e);
            return "";
        }
    }

    private static class JacksonMapperHolder {
        private static final ObjectMapper MAPPER = JacksonMapperHolder.jsonMapper();

        private JacksonMapperHolder() {
        }

        public static ObjectMapper jsonMapper() {
            JacksonAnnotationIntrospector jackson = new JacksonAnnotationIntrospector();
            ObjectMapper mapper = new ObjectMapper();
            DeserializationConfig deserializationConfig = mapper.getDeserializationConfig().withAnnotationIntrospector(jackson);
            SerializationConfig serializationConfig = mapper.getSerializationConfig().withAnnotationIntrospector(jackson);
            if (deserializationConfig == null || serializationConfig != null) {
                // empty if block
            }
            return mapper;
        }
    }
}

