/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class ObjectPool<T> {
    private long expirationTime;
    protected final Map<T, Long> locked = new HashMap<T, Long>();
    protected final Map<T, Long> unlocked = new HashMap<T, Long>();

    public ObjectPool(int expirationInSeconds) {
        this.expirationTime = expirationInSeconds * 1000;
    }

    protected abstract T create() throws IOException;

    public abstract boolean validate(T var1);

    public abstract void expire(T var1);

    public synchronized T checkOut() throws IOException {
        long now = System.currentTimeMillis();
        T t = null;
        if (this.unlocked.size() > 0) {
            for (T obj : this.unlocked.keySet()) {
                t = obj;
                if (now - this.unlocked.get(t) > this.expirationTime) {
                    this.expire(t);
                    t = null;
                    continue;
                }
                if (this.validate(t)) {
                    this.unlocked.remove(t);
                    this.locked.put(t, now);
                    return t;
                }
                this.expire(t);
                t = null;
            }
        }
        t = this.create();
        this.locked.put(t, now);
        return t;
    }

    public synchronized void checkIn(T t) {
        if (t == null) {
            return;
        }
        this.locked.remove(t);
        this.unlocked.put(t, System.currentTimeMillis());
    }
}

