/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.client;

import java.io.IOException;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxd.client.CommandClient;
import org.xdi.oxd.client.ObjectPool;

public class CommandClientPool
extends ObjectPool<CommandClient> {
    private static final Logger LOG = LoggerFactory.getLogger(CommandClientPool.class);
    private final ConcurrentSkipListSet<Integer> loggerNames = new ConcurrentSkipListSet();
    private final String host;
    private final int port;

    public CommandClientPool(int expirationInSeconds, String host, int port) {
        super(expirationInSeconds);
        this.host = host;
        this.port = port;
    }

    @Override
    protected CommandClient create() throws IOException {
        CommandClient client = new CommandClient(this.host, this.port);
        client.setNameForLogger(this.nextLoggerName());
        return client;
    }

    @Override
    public boolean validate(CommandClient o) {
        return o.isValid();
    }

    @Override
    public void expire(CommandClient o) {
        try {
            this.loggerNames.remove(o.getNameForLogger());
            this.locked.remove(o);
            this.unlocked.remove(o);
        }
        finally {
            CommandClient.closeQuietly(o);
        }
    }

    @Override
    public synchronized CommandClient checkOut() {
        try {
            return (CommandClient)super.checkOut();
        }
        catch (IOException e) {
            LOG.error("Failed to check out command client.", e);
            return null;
        }
    }

    private synchronized int nextLoggerName() {
        for (int i = 1; i < 10000; ++i) {
            if (this.loggerNames.contains(i)) continue;
            this.loggerNames.add(i);
            return i;
        }
        return -2;
    }
}

