/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.client;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxd.client.TransportClient;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandResponse;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.CoreUtils;
import org.xdi.oxd.common.params.LicenseStatusParams;
import org.xdi.oxd.common.response.LicenseStatusOpResponse;

public class CommandClient {
    private static final Logger LOG = LoggerFactory.getLogger(CommandClient.class);
    private TransportClient m_client;
    private boolean inUse = false;
    private int nameForLogger = -1;

    public CommandClient(String host, int port) throws IOException {
        this.m_client = new TransportClient(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResponse send(Command p_command) {
        if (p_command == null) {
            throw new IllegalArgumentException("Command is null");
        }
        this.inUse = true;
        try {
            String commandAsJson = CoreUtils.asJson(p_command);
            String responseAsJson = this.m_client.sendCommand(commandAsJson);
            if (StringUtils.isNotBlank(responseAsJson)) {
                CommandResponse commandResponse = CoreUtils.createJsonMapper().readValue(responseAsJson, CommandResponse.class);
                return commandResponse;
            }
            LOG.error("Server doesn't send any response.");
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), e);
        }
        finally {
            this.inUse = false;
        }
        return null;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void close() {
        if (this.m_client != null) {
            this.m_client.close();
        }
    }

    public static void closeQuietly(CommandClient p_client) {
        if (p_client != null) {
            p_client.close();
        }
    }

    public LicenseStatusOpResponse licenseStatus() {
        Command command = new Command(CommandType.LICENSE_STATUS);
        command.setParamsObject(new LicenseStatusParams());
        CommandResponse response = this.send(command);
        return response.dataAsResponse(LicenseStatusOpResponse.class);
    }

    public boolean isValid() {
        return this.m_client.isValid();
    }

    public int getNameForLogger() {
        return this.nameForLogger;
    }

    public void setNameForLogger(int nameForLogger) {
        this.nameForLogger = nameForLogger;
    }
}

