/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.util;

import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.openssl.PEMParser;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.xdi.oxauth.model.crypto.Certificate;
import org.xdi.oxauth.model.crypto.PublicKey;
import org.xdi.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.util.StringHelper;

public class JwtUtil {
    private static final Logger log = Logger.getLogger(JwtUtil.class);

    public static void printAlgorithmsAndProviders() {
        Provider[] providers;
        Set<String> algorithms = Security.getAlgorithms("Signature");
        for (String algorithm : algorithms) {
            log.trace("Algorithm (Signature): " + algorithm);
        }
        algorithms = Security.getAlgorithms("MessageDigest");
        for (String algorithm : algorithms) {
            log.trace("Algorithm (MessageDigest): " + algorithm);
        }
        algorithms = Security.getAlgorithms("Cipher");
        for (String algorithm : algorithms) {
            log.trace("Algorithm (Cipher): " + algorithm);
        }
        algorithms = Security.getAlgorithms("Mac");
        for (String algorithm : algorithms) {
            log.trace("Algorithm (Mac): " + algorithm);
        }
        algorithms = Security.getAlgorithms("KeyStore");
        for (String algorithm : algorithms) {
            log.trace("Algorithm (KeyStore): " + algorithm);
        }
        for (Provider provider : providers = Security.getProviders()) {
            log.trace("Provider: " + provider.getName());
        }
    }

    public static byte[] getMessageDigestSHA256(String data) throws NoSuchProviderException, NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest mda = MessageDigest.getInstance("SHA-256", "BC");
        return mda.digest(data.getBytes("UTF-8"));
    }

    public static byte[] getMessageDigestSHA384(String data) throws NoSuchProviderException, NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest mda = MessageDigest.getInstance("SHA-384", "BC");
        return mda.digest(data.getBytes("UTF-8"));
    }

    public static byte[] getMessageDigestSHA512(String data) throws NoSuchProviderException, NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest mda = MessageDigest.getInstance("SHA-512", "BC");
        return mda.digest(data.getBytes("UTF-8"));
    }

    public static PublicKey getPublicKey(String jwksUri, String jwks, SignatureAlgorithm signatureAlgorithm, String keyId) {
        log.debug("Retrieving JWK...");
        JSONObject jsonKeyValue = JwtUtil.getJsonKey(jwksUri, jwks, keyId);
        if (jsonKeyValue == null) {
            return null;
        }
        PublicKey publicKey = null;
        try {
            String resultKeyId = jsonKeyValue.getString("kid");
            if (signatureAlgorithm == null && (signatureAlgorithm = SignatureAlgorithm.fromString(jsonKeyValue.getString("alg"))) == null) {
                log.error(String.format("Failed to determine key '%s' signature algorithm", resultKeyId));
                return null;
            }
            JSONObject jsonPublicKey = jsonKeyValue;
            if (jsonKeyValue.has("publicKey")) {
                jsonPublicKey = jsonKeyValue.getJSONObject("publicKey");
            }
            if (signatureAlgorithm == SignatureAlgorithm.RS256 || signatureAlgorithm == SignatureAlgorithm.RS384 || signatureAlgorithm == SignatureAlgorithm.RS512) {
                String exp = jsonPublicKey.getString("e");
                String mod = jsonPublicKey.getString("n");
                BigInteger publicExponent = new BigInteger(1, Base64Util.base64urldecode(exp));
                BigInteger modulus = new BigInteger(1, Base64Util.base64urldecode(mod));
                publicKey = new RSAPublicKey(modulus, publicExponent);
            } else if (signatureAlgorithm == SignatureAlgorithm.ES256 || signatureAlgorithm == SignatureAlgorithm.ES384 || signatureAlgorithm == SignatureAlgorithm.ES512) {
                String xx = jsonPublicKey.getString("x");
                String yy = jsonPublicKey.getString("y");
                BigInteger x = new BigInteger(1, Base64Util.base64urldecode(xx));
                BigInteger y = new BigInteger(1, Base64Util.base64urldecode(yy));
                publicKey = new ECDSAPublicKey(signatureAlgorithm, x, y);
            }
            if (publicKey != null && jsonKeyValue.has("x5c")) {
                String BEGIN = "-----BEGIN CERTIFICATE-----";
                String END = "-----END CERTIFICATE-----";
                JSONArray certChain = jsonKeyValue.getJSONArray("x5c");
                String certificateString = "-----BEGIN CERTIFICATE-----\n" + certChain.getString(0) + "\n" + "-----END CERTIFICATE-----";
                StringReader sr = new StringReader(certificateString);
                PEMParser pemReader = new PEMParser(sr);
                X509CertificateObject cert = (X509CertificateObject)pemReader.readObject();
                Certificate certificate = new Certificate(signatureAlgorithm, cert);
                publicKey.setCertificate(certificate);
            }
            if (publicKey != null) {
                publicKey.setKeyId(resultKeyId);
                publicKey.setSignatureAlgorithm(signatureAlgorithm);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
        return publicKey;
    }

    public static JSONObject getJsonKey(String jwksUri, String jwks, String keyId) {
        JSONObject jsonKey;
        block6: {
            log.debug("Retrieving JWK Key...");
            jsonKey = null;
            try {
                JSONObject jsonObject;
                JSONArray keys;
                if (StringHelper.isEmpty(jwks)) {
                    ClientRequest clientRequest = new ClientRequest(jwksUri);
                    clientRequest.setHttpMethod("GET");
                    ClientResponse<String> clientResponse = clientRequest.get(String.class);
                    int status = clientResponse.getStatus();
                    log.debug(String.format("Status: %n%d", status));
                    if (status == 200) {
                        jwks = clientResponse.getEntity(String.class);
                        log.debug(String.format("JWK: %s", jwks));
                    }
                }
                if (!StringHelper.isNotEmpty(jwks) || (keys = (jsonObject = new JSONObject(jwks)).getJSONArray("keys")).length() <= 0) break block6;
                if (StringHelper.isEmpty(keyId)) {
                    jsonKey = keys.getJSONObject(0);
                    break block6;
                }
                for (int i = 0; i < keys.length(); ++i) {
                    JSONObject kv = keys.getJSONObject(i);
                    if (!kv.getString("kid").equals(keyId)) continue;
                    jsonKey = kv;
                    break;
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), ex);
            }
        }
        return jsonKey;
    }

    public static JSONObject getJSONWebKeys(String jwksUri) {
        log.debug("Retrieving jwks...");
        JSONObject jwks = null;
        try {
            if (!StringHelper.isEmpty(jwksUri)) {
                ClientRequest clientRequest = new ClientRequest(jwksUri);
                clientRequest.setHttpMethod("GET");
                ClientResponse<String> clientResponse = clientRequest.get(String.class);
                int status = clientResponse.getStatus();
                log.debug(String.format("Status: %n%d", status));
                if (status == 200) {
                    jwks = new JSONObject(clientResponse.getEntity(String.class));
                    log.debug(String.format("JWK: %s", jwks));
                }
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
        return jwks;
    }
}

