/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.util;

import java.math.BigInteger;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class Base64Util {
    private static final Logger log = Logger.getLogger(Base64Util.class);

    public static String base64urlencode(byte[] arg) {
        String s = Base64.encodeBase64String(arg);
        s = s.split("=")[0];
        s = s.replace('+', '-');
        s = s.replace('/', '_');
        return s;
    }

    public static byte[] base64urldecode(String arg) throws IllegalArgumentException {
        String s = Base64Util.removePadding(arg);
        return Base64.decodeBase64(s);
    }

    public static String removePadding(String base64UrlEncoded) {
        String s = base64UrlEncoded;
        s = s.replace('-', '+');
        s = s.replace('_', '/');
        switch (s.length() % 4) {
            case 0: {
                break;
            }
            case 2: {
                s = s + "==";
                break;
            }
            case 3: {
                s = s + "=";
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal base64url string.");
            }
        }
        return s;
    }

    public static String base64urlencodeUnsignedBigInt(BigInteger bigInteger) {
        byte[] array = bigInteger.toByteArray();
        if (array[0] == 0) {
            byte[] tmp = new byte[array.length - 1];
            System.arraycopy(array, 1, tmp, 0, tmp.length);
            array = tmp;
        }
        return Base64Util.base64urlencode(array);
    }

    public static byte[] unsignedToBytes(int[] plaintextUnsignedBytes) {
        byte[] bytes = new byte[plaintextUnsignedBytes.length];
        for (int i = 0; i < plaintextUnsignedBytes.length; ++i) {
            bytes[i] = (byte)plaintextUnsignedBytes[i];
        }
        return bytes;
    }
}

